/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.AbstractAlgorithm;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.signature.DSASignature;
import edu.vt.middleware.crypt.signature.RSASignature;
import edu.vt.middleware.crypt.util.Converter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class SignatureAlgorithm
extends AbstractAlgorithm {
    private static final Map<String, Class<? extends SignatureAlgorithm>> NAME_CLASS_MAP = new HashMap<String, Class<? extends SignatureAlgorithm>>();
    protected PrivateKey signKey;
    protected PublicKey verifyKey;
    protected DigestAlgorithm digest;

    protected SignatureAlgorithm(String alg) {
        this.algorithm = alg;
    }

    public static SignatureAlgorithm newInstance(String algorithm) {
        Class<? extends SignatureAlgorithm> clazz = NAME_CLASS_MAP.get(algorithm.toUpperCase());
        if (clazz == null) {
            throw new IllegalArgumentException("Signature " + algorithm + " is not available.");
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static SignatureAlgorithm newInstance(String algorithm, String digestAlgorithm) {
        Class<? extends SignatureAlgorithm> clazz = NAME_CLASS_MAP.get(algorithm.toUpperCase());
        if (clazz == null) {
            throw new IllegalArgumentException("Signature " + algorithm + " is not available.");
        }
        try {
            Constructor<? extends SignatureAlgorithm> cons = clazz.getConstructor(DigestAlgorithm.class);
            return cons.newInstance(DigestAlgorithm.newInstance(digestAlgorithm));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public void setSignKey(PrivateKey key) {
        this.signKey = key;
    }

    public void setVerifyKey(PublicKey key) {
        this.verifyKey = key;
    }

    public void initSign() throws CryptException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void initVerify() throws CryptException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public byte[] sign(byte[] data) throws CryptException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String sign(byte[] data, Converter converter) throws CryptException {
        return converter.fromBytes(this.sign(data));
    }

    public byte[] sign(InputStream in) throws CryptException, IOException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String sign(InputStream in, Converter converter) throws CryptException, IOException {
        return converter.fromBytes(this.sign(in));
    }

    public boolean verify(byte[] data, byte[] signature) throws CryptException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public boolean verify(byte[] data, String signature, Converter converter) throws CryptException {
        return this.verify(data, converter.toBytes(signature));
    }

    public boolean verify(InputStream in, byte[] signature) throws CryptException, IOException {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public boolean verify(InputStream in, String signature, Converter converter) throws CryptException, IOException {
        return this.verify(in, converter.toBytes(signature));
    }

    static {
        NAME_CLASS_MAP.put("DSA", DSASignature.class);
        NAME_CLASS_MAP.put("RSA", RSASignature.class);
    }
}

