/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pkcs;

import edu.vt.middleware.crypt.pkcs.PBEParameter;
import edu.vt.middleware.crypt.util.DERHelper;
import org.bouncycastle.asn1.DERSequence;

public class PBKDF2Parameters
extends PBEParameter {
    private int length;

    public PBKDF2Parameters(byte[] saltBytes, int iterations) {
        super(saltBytes, iterations);
    }

    public PBKDF2Parameters(byte[] saltBytes, int iterations, int keyByteLength) {
        super(saltBytes, iterations);
        this.setLength(keyByteLength);
    }

    public static PBKDF2Parameters decode(DERSequence params) {
        DERSequence kdfSeq = (DERSequence)params.getObjectAt(1);
        PBKDF2Parameters instance = new PBKDF2Parameters(DERHelper.asOctets(kdfSeq.getObjectAt(0)), DERHelper.asInt(kdfSeq.getObjectAt(1)));
        if (kdfSeq.size() > 2) {
            instance.setLength(DERHelper.asInt(kdfSeq.getObjectAt(2)) * 8);
        }
        return instance;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int byteLength) {
        if (byteLength < 1) {
            throw new IllegalArgumentException("Key length must be positive integer.");
        }
        this.length = byteLength;
    }
}

