/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pkcs;

import edu.vt.middleware.crypt.symmetric.AlgorithmSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PBES2Algorithm {
    DES("1.3.14.3.2.7", new AlgorithmSpec("DES", "CBC", "PKCS5Padding"), 64),
    DESede("1.2.840.113549.3.7", new AlgorithmSpec("DESede", "CBC", "PKCS5Padding"), 192),
    RC2("1.2.840.113549.3.2", new AlgorithmSpec("RC2", "CBC", "PKCS5Padding"), -1),
    RC5("1.2.840.113549.3.9", new AlgorithmSpec("RC5", "CBC", "PKCS5Padding"), -1),
    AES128("2.16.840.1.101.3.4.1.2", new AlgorithmSpec("AES", "CBC", "PKCS5Padding"), 128),
    AES192("2.16.840.1.101.3.4.1.22", new AlgorithmSpec("AES", "CBC", "PKCS5Padding"), 192),
    AES256("2.16.840.1.101.3.4.1.42", new AlgorithmSpec("AES", "CBC", "PKCS5Padding"), 256);

    private String oid;
    private AlgorithmSpec spec;
    private int keySize;

    private PBES2Algorithm(String id, AlgorithmSpec cipherSpec, int keySizeBits) {
        this.oid = id;
        this.spec = cipherSpec;
        this.keySize = keySizeBits;
    }

    public static PBES2Algorithm fromOid(String oid) {
        for (PBES2Algorithm a : PBES2Algorithm.values()) {
            if (!a.getOid().equals(oid)) continue;
            return a;
        }
        throw new IllegalArgumentException("Unknown PBES1Algorithm for OID " + oid);
    }

    public String getOid() {
        return this.oid;
    }

    public AlgorithmSpec getSpec() {
        return this.spec;
    }

    public int getKeySize() {
        return this.keySize;
    }
}

