/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pkcs;

import edu.vt.middleware.crypt.util.DERHelper;
import org.bouncycastle.asn1.DERSequence;

public class PBEParameter {
    protected byte[] salt;
    protected int iterationCount;

    public PBEParameter(byte[] saltBytes, int iterations) {
        if (iterations < 1) {
            throw new IllegalArgumentException("Iterations must be greater than 0.");
        }
        this.salt = saltBytes;
        this.iterationCount = iterations;
    }

    public static PBEParameter decode(DERSequence params) {
        return new PBEParameter(DERHelper.asOctets(params.getObjectAt(0)), DERHelper.asInt(params.getObjectAt(1)));
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }
}

