/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import edu.vt.middleware.crypt.CryptException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class CryptProvider {
    public static final int RANDOM_BYTE_ARRAY_SIZE = 256;
    private static String[] providers = new String[0];

    private CryptProvider() {
    }

    public static void addProvider(Provider provider, String name) {
        Security.addProvider(provider);
        String[] tmp = new String[providers.length + 1];
        for (int i = 0; i < providers.length; ++i) {
            tmp[i] = providers[i];
        }
        tmp[CryptProvider.providers.length] = name;
        providers = tmp;
        Log logger = LogFactory.getLog(CryptProvider.class);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Added new security provider " + name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cipher getCipher(String algorithm, String mode, String padding) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        Cipher cipher = null;
        String transformation = null;
        transformation = mode != null && padding != null ? algorithm + "/" + mode + "/" + padding : (mode != null ? algorithm + "/" + mode : algorithm);
        for (int i = 0; i < providers.length; ++i) {
            try {
                cipher = Cipher.getInstance(transformation, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            catch (NoSuchPaddingException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find padding " + padding + " in " + providers[i]));
                }
            }
            finally {
                if (cipher != null) break;
            }
        }
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(transformation);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find padding " + padding));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return cipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecretKeyFactory getSecretKeyFactory(String algorithm) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        SecretKeyFactory kf = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                kf = SecretKeyFactory.getInstance(algorithm, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (kf != null) break;
            }
        }
        if (kf == null) {
            try {
                kf = SecretKeyFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return kf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyFactory getKeyFactory(String algorithm) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        KeyFactory kf = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                kf = KeyFactory.getInstance(algorithm, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (kf != null) break;
            }
        }
        if (kf == null) {
            try {
                kf = KeyFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return kf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyGenerator getKeyGenerator(String algorithm) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        KeyGenerator generator = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                generator = KeyGenerator.getInstance(algorithm, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (generator != null) break;
            }
        }
        if (generator == null) {
            try {
                generator = KeyGenerator.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        KeyPairGenerator generator = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                generator = KeyPairGenerator.getInstance(algorithm, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (generator != null) break;
            }
        }
        if (generator == null) {
            try {
                generator = KeyPairGenerator.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Signature getSignature(String digestAlgorithm, String algorithm, String padding) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        Signature sig = null;
        String transformation = null;
        transformation = digestAlgorithm != null && padding != null ? digestAlgorithm + "/" + algorithm + "/" + padding : (digestAlgorithm != null ? digestAlgorithm + "/" + algorithm : algorithm);
        for (int i = 0; i < providers.length; ++i) {
            try {
                sig = Signature.getInstance(transformation, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (sig != null) break;
            }
        }
        if (sig == null) {
            try {
                sig = Signature.getInstance(transformation);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return sig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageDigest getMessageDigest(String algorithm) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        MessageDigest digest = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                digest = MessageDigest.getInstance(algorithm, providers[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm + " in " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (digest != null) break;
            }
        }
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find algorithm " + algorithm));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getKeyStore(String type) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        KeyStore store = null;
        String keyStoreType = type;
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        for (int i = 0; i < providers.length; ++i) {
            try {
                store = KeyStore.getInstance(keyStoreType, providers[i]);
                continue;
            }
            catch (KeyStoreException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not get instance of keystore type " + type + " from " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (store != null) break;
            }
        }
        if (store == null) {
            try {
                store = KeyStore.getInstance(keyStoreType);
            }
            catch (KeyStoreException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not get instance of keystore type " + type));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return store;
    }

    public static KeyStore getKeyStore() throws CryptException {
        return CryptProvider.getKeyStore(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CertificateFactory getCertificateFactory(String type) throws CryptException {
        Log logger = LogFactory.getLog(CryptProvider.class);
        CertificateFactory cf = null;
        for (int i = 0; i < providers.length; ++i) {
            try {
                cf = CertificateFactory.getInstance(type, providers[i]);
                continue;
            }
            catch (CertificateException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not get instance of certificate factory type " + type + " from " + providers[i]));
                }
            }
            catch (NoSuchProviderException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not find provider " + providers[i]));
                }
            }
            finally {
                if (cf != null) break;
            }
        }
        if (cf == null) {
            try {
                cf = CertificateFactory.getInstance(type);
            }
            catch (CertificateException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Could not get instance of certificate factory type " + type));
                }
                throw new CryptException(e.getMessage());
            }
        }
        return cf;
    }

    static {
        CryptProvider.addProvider((Provider)new BouncyCastleProvider(), "BC");
    }
}

