/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractCli {
    protected static final String OPT_INFILE = "in";
    protected static final String OPT_EXAMPLE = "examples";
    protected static final String BASE_64_ENCODING = "base64";
    protected static final String HEX_ENCODING = "hex";
    protected static final String PEM_SUFFIX = "pem";
    protected Options options = new Options();

    public final void performAction(String[] args) {
        this.initOptions();
        try {
            if (args.length > 0) {
                GnuParser parser = new GnuParser();
                CommandLine line = parser.parse(this.options, args);
                if (line.hasOption(OPT_EXAMPLE)) {
                    this.printExamples();
                } else {
                    this.dispatch(line);
                }
            } else {
                this.printHelp();
            }
        }
        catch (ParseException pex) {
            System.err.println("Failed parsing command arguments: " + pex.getMessage());
        }
        catch (IllegalArgumentException iaex) {
            String msg = "Operation failed: " + iaex.getMessage();
            if (iaex.getCause() != null) {
                msg = msg + " Underlying reason: " + iaex.getCause().getMessage();
            }
            System.err.println(msg);
        }
        catch (Exception ex) {
            System.err.println("Operation failed:");
            ex.printStackTrace(System.err);
        }
    }

    protected void initOptions() {
        this.options.addOption(new Option(OPT_EXAMPLE, "print usage examples"));
        this.options.addOption(new Option("help", "print a command summary"));
    }

    protected abstract String getCommandName();

    protected abstract void dispatch(CommandLine var1) throws Exception;

    protected void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.getCommandName(), this.options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printExamples() {
        String fullName = this.getClass().getName();
        String name = fullName.substring(fullName.lastIndexOf(46) + 1);
        InputStream in = this.getClass().getResourceAsStream(name + ".examples");
        if (in != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                System.out.println();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading examples from resource stream.");
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    System.err.println("Error closing example resource stream.");
                }
                System.out.println();
            }
        } else {
            System.out.println("No usage examples available for " + this.getCommandName());
        }
    }

    protected InputStream getInputStream(CommandLine line) throws IOException {
        return this.getInputStream(line, OPT_INFILE);
    }

    protected InputStream getInputStream(CommandLine line, String opt) throws IOException {
        InputStream in = null;
        if (line.hasOption(opt)) {
            File file = new File(line.getOptionValue(opt));
            System.err.println("Reading input from " + file);
            in = new BufferedInputStream(new FileInputStream(file));
        } else {
            System.err.println("Reading input from STDIN");
            in = System.in;
        }
        return in;
    }

    protected void closeStream(InputStream in) {
        try {
            if (in != System.in) {
                in.close();
            }
        }
        catch (IOException ioex) {
            System.err.println("Error closing input stream.");
        }
    }

    protected void closeStream(OutputStream out) {
        try {
            out.flush();
            if (out != System.out) {
                out.close();
            }
        }
        catch (IOException ioex) {
            System.err.println("Error closing output stream.");
        }
    }
}

