/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.util.LinkedList;
import java.util.List;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.opensaml.xmlsec.signature.support.ContentReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIContentReference
implements ContentReference {
    private final Logger log = LoggerFactory.getLogger(URIContentReference.class);
    private String referenceID;
    private String digestAlgorithm;
    private List<String> transforms;

    public URIContentReference(String referenceID) {
        this.referenceID = referenceID;
        this.transforms = new LinkedList<String>();
    }

    public List<String> getTransforms() {
        return this.transforms;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String newAlgorithm) {
        this.digestAlgorithm = newAlgorithm;
    }

    @Override
    public void createReference(XMLSignature signature) {
        try {
            Transforms dsigTransforms = new Transforms(signature.getDocument());
            for (String transform : this.transforms) {
                dsigTransforms.addTransform(transform);
            }
            signature.addDocument(this.referenceID, dsigTransforms, this.digestAlgorithm);
        }
        catch (Exception e) {
            this.log.error("Error while adding content reference", (Throwable)e);
        }
    }
}

