/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;

public class NamedKeyInfoGeneratorManager {
    private Map<String, KeyInfoGeneratorManager> managers = new LazyMap();
    private KeyInfoGeneratorManager defaultManager = new KeyInfoGeneratorManager();
    private boolean useDefaultManager = true;

    public void setUseDefaultManager(boolean newValue) {
        this.useDefaultManager = newValue;
    }

    public Set<String> getManagerNames() {
        return Collections.unmodifiableSet(this.managers.keySet());
    }

    public KeyInfoGeneratorManager getManager(String name) {
        KeyInfoGeneratorManager manager = this.managers.get(name);
        if (manager == null) {
            manager = new KeyInfoGeneratorManager();
            this.managers.put(name, manager);
        }
        return manager;
    }

    public void removeManager(String name) {
        this.managers.remove(name);
    }

    public void registerFactory(String name, KeyInfoGeneratorFactory factory) {
        KeyInfoGeneratorManager manager = this.getManager(name);
        manager.registerFactory(factory);
    }

    public void deregisterFactory(String name, KeyInfoGeneratorFactory factory) {
        KeyInfoGeneratorManager manager = this.managers.get(name);
        if (manager == null) {
            throw new IllegalArgumentException("Manager with name '" + name + "' does not exist");
        }
        manager.deregisterFactory(factory);
    }

    public void registerDefaultFactory(KeyInfoGeneratorFactory factory) {
        this.defaultManager.registerFactory(factory);
    }

    public void deregisterDefaultFactory(KeyInfoGeneratorFactory factory) {
        this.defaultManager.deregisterFactory(factory);
    }

    public KeyInfoGeneratorManager getDefaultManager() {
        return this.defaultManager;
    }

    public KeyInfoGeneratorFactory getFactory(String name, Credential credential) {
        KeyInfoGeneratorManager manager = this.managers.get(name);
        if (manager == null) {
            throw new IllegalArgumentException("Manager with name '" + name + "' does not exist");
        }
        KeyInfoGeneratorFactory factory = manager.getFactory(credential);
        if (factory == null && this.useDefaultManager) {
            factory = this.defaultManager.getFactory(credential);
        }
        return factory;
    }
}

