/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.LinkedList;
import java.util.List;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SecurityConfiguration;
import org.opensaml.xmlsec.SecurityConfigurationSupport;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.signature.DSAKeyValue;
import org.opensaml.xmlsec.signature.Exponent;
import org.opensaml.xmlsec.signature.G;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.Modulus;
import org.opensaml.xmlsec.signature.P;
import org.opensaml.xmlsec.signature.Q;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.opensaml.xmlsec.signature.X509CRL;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509IssuerName;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SerialNumber;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.opensaml.xmlsec.signature.Y;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyInfoSupport {
    private static CertificateFactory x509CertFactory;

    protected KeyInfoSupport() {
    }

    public static List<String> getKeyNames(KeyInfo keyInfo) {
        LinkedList<String> keynameList = new LinkedList<String>();
        if (keyInfo == null) {
            return keynameList;
        }
        List<KeyName> keyNames = keyInfo.getKeyNames();
        for (KeyName keyName : keyNames) {
            if (keyName.getValue() == null) continue;
            keynameList.add(keyName.getValue());
        }
        return keynameList;
    }

    public static void addKeyName(KeyInfo keyInfo, String keyNameValue) {
        KeyName keyName = (KeyName)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(KeyName.DEFAULT_ELEMENT_NAME).buildObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(keyNameValue);
        keyInfo.getKeyNames().add(keyName);
    }

    public static List<java.security.cert.X509Certificate> getCertificates(KeyInfo keyInfo) throws CertificateException {
        LinkedList<java.security.cert.X509Certificate> certList = new LinkedList<java.security.cert.X509Certificate>();
        if (keyInfo == null) {
            return certList;
        }
        List<X509Data> x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            if (x509Data == null) continue;
            certList.addAll(KeyInfoSupport.getCertificates(x509Data));
        }
        return certList;
    }

    public static List<java.security.cert.X509Certificate> getCertificates(X509Data x509Data) throws CertificateException {
        LinkedList<java.security.cert.X509Certificate> certList = new LinkedList<java.security.cert.X509Certificate>();
        if (x509Data == null) {
            return certList;
        }
        for (X509Certificate xmlCert : x509Data.getX509Certificates()) {
            if (xmlCert == null || xmlCert.getValue() == null) continue;
            java.security.cert.X509Certificate newCert = KeyInfoSupport.getCertificate(xmlCert);
            certList.add(newCert);
        }
        return certList;
    }

    public static java.security.cert.X509Certificate getCertificate(X509Certificate xmlCert) throws CertificateException {
        if (xmlCert == null || xmlCert.getValue() == null) {
            return null;
        }
        return X509Support.decodeCertificate((String)xmlCert.getValue());
    }

    public static List<java.security.cert.X509CRL> getCRLs(KeyInfo keyInfo) throws CRLException {
        LinkedList<java.security.cert.X509CRL> crlList = new LinkedList<java.security.cert.X509CRL>();
        if (keyInfo == null) {
            return crlList;
        }
        List<X509Data> x509Datas = keyInfo.getX509Datas();
        for (X509Data x509Data : x509Datas) {
            if (x509Data == null) continue;
            crlList.addAll(KeyInfoSupport.getCRLs(x509Data));
        }
        return crlList;
    }

    public static List<java.security.cert.X509CRL> getCRLs(X509Data x509Data) throws CRLException {
        LinkedList<java.security.cert.X509CRL> crlList = new LinkedList<java.security.cert.X509CRL>();
        if (x509Data == null) {
            return crlList;
        }
        for (X509CRL xmlCRL : x509Data.getX509CRLs()) {
            if (xmlCRL == null || xmlCRL.getValue() == null) continue;
            java.security.cert.X509CRL newCRL = KeyInfoSupport.getCRL(xmlCRL);
            crlList.add(newCRL);
        }
        return crlList;
    }

    public static java.security.cert.X509CRL getCRL(X509CRL xmlCRL) throws CRLException {
        if (xmlCRL == null || xmlCRL.getValue() == null) {
            return null;
        }
        try {
            return X509Support.decodeCRL((String)xmlCRL.getValue());
        }
        catch (CertificateException e) {
            throw new CRLException("Certificate error attempting to decode CRL", e);
        }
    }

    public static void addCertificate(KeyInfo keyInfo, java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        X509Data x509Data;
        if (keyInfo.getX509Datas().size() == 0) {
            x509Data = (X509Data)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(X509Data.DEFAULT_ELEMENT_NAME).buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            keyInfo.getX509Datas().add(x509Data);
        } else {
            x509Data = keyInfo.getX509Datas().get(0);
        }
        x509Data.getX509Certificates().add(KeyInfoSupport.buildX509Certificate(cert));
    }

    public static void addCRL(KeyInfo keyInfo, java.security.cert.X509CRL crl) throws CRLException {
        X509Data x509Data;
        if (keyInfo.getX509Datas().size() == 0) {
            x509Data = (X509Data)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(X509Data.DEFAULT_ELEMENT_NAME).buildObject(X509Data.DEFAULT_ELEMENT_NAME);
            keyInfo.getX509Datas().add(x509Data);
        } else {
            x509Data = keyInfo.getX509Datas().get(0);
        }
        x509Data.getX509CRLs().add(KeyInfoSupport.buildX509CRL(crl));
    }

    public static X509Certificate buildX509Certificate(java.security.cert.X509Certificate cert) throws CertificateEncodingException {
        X509Certificate xmlCert = (X509Certificate)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(X509Certificate.DEFAULT_ELEMENT_NAME).buildObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        xmlCert.setValue(Base64Support.encode((byte[])cert.getEncoded(), (boolean)true));
        return xmlCert;
    }

    public static X509CRL buildX509CRL(java.security.cert.X509CRL crl) throws CRLException {
        X509CRL xmlCRL = (X509CRL)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(X509CRL.DEFAULT_ELEMENT_NAME).buildObject(X509CRL.DEFAULT_ELEMENT_NAME);
        xmlCRL.setValue(Base64Support.encode((byte[])crl.getEncoded(), (boolean)true));
        return xmlCRL;
    }

    public static X509SubjectName buildX509SubjectName(String subjectName) {
        X509SubjectName xmlSubjectName = (X509SubjectName)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(X509SubjectName.DEFAULT_ELEMENT_NAME).buildObject(X509SubjectName.DEFAULT_ELEMENT_NAME);
        xmlSubjectName.setValue(subjectName);
        return xmlSubjectName;
    }

    public static X509IssuerSerial buildX509IssuerSerial(String issuerName, BigInteger serialNumber) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        X509IssuerName xmlIssuerName = (X509IssuerName)builderFactory.getBuilder(X509IssuerName.DEFAULT_ELEMENT_NAME).buildObject(X509IssuerName.DEFAULT_ELEMENT_NAME);
        xmlIssuerName.setValue(issuerName);
        X509SerialNumber xmlSerialNumber = (X509SerialNumber)builderFactory.getBuilder(X509SerialNumber.DEFAULT_ELEMENT_NAME).buildObject(X509SerialNumber.DEFAULT_ELEMENT_NAME);
        xmlSerialNumber.setValue(serialNumber);
        X509IssuerSerial xmlIssuerSerial = (X509IssuerSerial)builderFactory.getBuilder(X509IssuerSerial.DEFAULT_ELEMENT_NAME).buildObject(X509IssuerSerial.DEFAULT_ELEMENT_NAME);
        xmlIssuerSerial.setX509IssuerName(xmlIssuerName);
        xmlIssuerSerial.setX509SerialNumber(xmlSerialNumber);
        return xmlIssuerSerial;
    }

    public static X509SKI buildX509SKI(java.security.cert.X509Certificate javaCert) {
        byte[] skiPlainValue = X509Support.getSubjectKeyIdentifier((java.security.cert.X509Certificate)javaCert);
        if (skiPlainValue == null || skiPlainValue.length == 0) {
            return null;
        }
        X509SKI xmlSKI = (X509SKI)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(X509SKI.DEFAULT_ELEMENT_NAME).buildObject(X509SKI.DEFAULT_ELEMENT_NAME);
        xmlSKI.setValue(Base64Support.encode((byte[])skiPlainValue, (boolean)true));
        return xmlSKI;
    }

    public static void addPublicKey(KeyInfo keyInfo, PublicKey pk) {
        KeyValue keyValue = (KeyValue)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(KeyValue.DEFAULT_ELEMENT_NAME).buildObject(KeyValue.DEFAULT_ELEMENT_NAME);
        if (pk instanceof RSAPublicKey) {
            keyValue.setRSAKeyValue(KeyInfoSupport.buildRSAKeyValue((RSAPublicKey)pk));
        } else if (pk instanceof DSAPublicKey) {
            keyValue.setDSAKeyValue(KeyInfoSupport.buildDSAKeyValue((DSAPublicKey)pk));
        } else {
            throw new IllegalArgumentException("Only RSAPublicKey and DSAPublicKey are supported");
        }
        keyInfo.getKeyValues().add(keyValue);
    }

    public static RSAKeyValue buildRSAKeyValue(RSAPublicKey rsaPubKey) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        RSAKeyValue rsaKeyValue = (RSAKeyValue)builderFactory.getBuilder(RSAKeyValue.DEFAULT_ELEMENT_NAME).buildObject(RSAKeyValue.DEFAULT_ELEMENT_NAME);
        Modulus modulus = (Modulus)builderFactory.getBuilder(Modulus.DEFAULT_ELEMENT_NAME).buildObject(Modulus.DEFAULT_ELEMENT_NAME);
        Exponent exponent = (Exponent)builderFactory.getBuilder(Exponent.DEFAULT_ELEMENT_NAME).buildObject(Exponent.DEFAULT_ELEMENT_NAME);
        modulus.setValueBigInt(rsaPubKey.getModulus());
        rsaKeyValue.setModulus(modulus);
        exponent.setValueBigInt(rsaPubKey.getPublicExponent());
        rsaKeyValue.setExponent(exponent);
        return rsaKeyValue;
    }

    public static DSAKeyValue buildDSAKeyValue(DSAPublicKey dsaPubKey) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        DSAKeyValue dsaKeyValue = (DSAKeyValue)builderFactory.getBuilder(DSAKeyValue.DEFAULT_ELEMENT_NAME).buildObject(DSAKeyValue.DEFAULT_ELEMENT_NAME);
        Y y = (Y)builderFactory.getBuilder(Y.DEFAULT_ELEMENT_NAME).buildObject(Y.DEFAULT_ELEMENT_NAME);
        G g = (G)builderFactory.getBuilder(G.DEFAULT_ELEMENT_NAME).buildObject(G.DEFAULT_ELEMENT_NAME);
        P p = (P)builderFactory.getBuilder(P.DEFAULT_ELEMENT_NAME).buildObject(P.DEFAULT_ELEMENT_NAME);
        Q q = (Q)builderFactory.getBuilder(Q.DEFAULT_ELEMENT_NAME).buildObject(Q.DEFAULT_ELEMENT_NAME);
        y.setValueBigInt(dsaPubKey.getY());
        dsaKeyValue.setY(y);
        g.setValueBigInt(dsaPubKey.getParams().getG());
        dsaKeyValue.setG(g);
        p.setValueBigInt(dsaPubKey.getParams().getP());
        dsaKeyValue.setP(p);
        q.setValueBigInt(dsaPubKey.getParams().getQ());
        dsaKeyValue.setQ(q);
        return dsaKeyValue;
    }

    public static List<PublicKey> getPublicKeys(KeyInfo keyInfo) throws KeyException {
        LinkedList<PublicKey> keys = new LinkedList<PublicKey>();
        if (keyInfo == null || keyInfo.getKeyValues() == null) {
            return keys;
        }
        for (KeyValue keyDescriptor : keyInfo.getKeyValues()) {
            keys.add(KeyInfoSupport.getKey(keyDescriptor));
        }
        return keys;
    }

    public static PublicKey getKey(KeyValue keyValue) throws KeyException {
        if (keyValue.getDSAKeyValue() != null) {
            return KeyInfoSupport.getDSAKey(keyValue.getDSAKeyValue());
        }
        if (keyValue.getRSAKeyValue() != null) {
            return KeyInfoSupport.getRSAKey(keyValue.getRSAKeyValue());
        }
        return null;
    }

    public static PublicKey getDSAKey(DSAKeyValue keyDescriptor) throws KeyException {
        if (!KeyInfoSupport.hasCompleteDSAParams(keyDescriptor)) {
            throw new KeyException("DSAKeyValue element did not contain at least one of DSA parameters P, Q or G");
        }
        BigInteger gComponent = keyDescriptor.getG().getValueBigInt();
        BigInteger pComponent = keyDescriptor.getP().getValueBigInt();
        BigInteger qComponent = keyDescriptor.getQ().getValueBigInt();
        DSAParameterSpec dsaParams = new DSAParameterSpec(pComponent, qComponent, gComponent);
        return KeyInfoSupport.getDSAKey(keyDescriptor, dsaParams);
    }

    public static PublicKey getDSAKey(DSAKeyValue keyDescriptor, DSAParams dsaParams) throws KeyException {
        BigInteger yComponent = keyDescriptor.getY().getValueBigInt();
        DSAPublicKeySpec keySpec = new DSAPublicKeySpec(yComponent, dsaParams.getP(), dsaParams.getQ(), dsaParams.getG());
        return KeyInfoSupport.buildKey(keySpec, "DSA");
    }

    public static boolean hasCompleteDSAParams(DSAKeyValue keyDescriptor) {
        return keyDescriptor.getG() != null && !Strings.isNullOrEmpty((String)keyDescriptor.getG().getValue()) && keyDescriptor.getP() != null && !Strings.isNullOrEmpty((String)keyDescriptor.getP().getValue()) && keyDescriptor.getQ() != null && !Strings.isNullOrEmpty((String)keyDescriptor.getQ().getValue());
    }

    public static PublicKey getRSAKey(RSAKeyValue keyDescriptor) throws KeyException {
        BigInteger modulus = keyDescriptor.getModulus().getValueBigInt();
        BigInteger exponent = keyDescriptor.getExponent().getValueBigInt();
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
        return KeyInfoSupport.buildKey(keySpec, "RSA");
    }

    public static final BigInteger decodeBigIntegerFromCryptoBinary(String base64Value) {
        return new BigInteger(1, Base64Support.decode((String)base64Value));
    }

    public static final String encodeCryptoBinaryFromBigInteger(BigInteger bigInt) {
        byte[] bigIntBytes = Base64.encode((BigInteger)bigInt, (int)bigInt.bitLength());
        return Base64Support.encode((byte[])bigIntBytes, (boolean)false);
    }

    protected static PublicKey buildKey(KeySpec keySpec, String keyAlgorithm) throws KeyException {
        Logger log = KeyInfoSupport.getLogger();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(keyAlgorithm + " algorithm is not supported by this VM", (Throwable)e);
            throw new KeyException(keyAlgorithm + "algorithm is not supported by the JCE", e);
        }
        catch (InvalidKeySpecException e) {
            log.error("Invalid key information", (Throwable)e);
            throw new KeyException("Invalid key information", e);
        }
    }

    protected static CertificateFactory getX509CertFactory() throws CertificateException {
        if (x509CertFactory == null) {
            x509CertFactory = CertificateFactory.getInstance("X.509");
        }
        return x509CertFactory;
    }

    public static KeyInfoGenerator getKeyInfoGenerator(Credential credential, SecurityConfiguration config, String keyInfoGenName) {
        SecurityConfiguration secConfig = config != null ? config : SecurityConfigurationSupport.getGlobalXMLSecurityConfiguration();
        NamedKeyInfoGeneratorManager kiMgr = secConfig.getKeyInfoGeneratorManager();
        if (kiMgr != null) {
            KeyInfoGeneratorFactory kiFactory = null;
            kiFactory = Strings.isNullOrEmpty((String)keyInfoGenName) ? kiMgr.getDefaultManager().getFactory(credential) : kiMgr.getFactory(keyInfoGenName, credential);
            if (kiFactory != null) {
                return kiFactory.newInstance();
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(KeyInfoSupport.class);
    }
}

