/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.crypto;

import com.google.common.base.Strings;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlgorithmSupport {
    private static Set<String> rsaAlgorithmURIs;
    private static Set<String> dsaAlgorithmURIs;
    private static Set<String> ecdsaAlgorithmURIs;

    private AlgorithmSupport() {
    }

    public static String getAlgorithmID(String algorithmURI) {
        return StringSupport.trimOrNull((String)JCEMapper.translateURItoJCEID((String)algorithmURI));
    }

    public static boolean isHMAC(String signatureAlgorithm) {
        String algoClass = StringSupport.trimOrNull((String)JCEMapper.getAlgorithmClassFromURI((String)signatureAlgorithm));
        return "Mac".equals(algoClass);
    }

    public static String getKeyAlgorithm(String algorithmURI) {
        String apacheValue = StringSupport.trimOrNull((String)JCEMapper.getJCEKeyAlgorithmFromURI((String)algorithmURI));
        if (apacheValue != null) {
            return apacheValue;
        }
        if (AlgorithmSupport.isHMAC(algorithmURI)) {
            return null;
        }
        if (rsaAlgorithmURIs.contains(algorithmURI)) {
            return "RSA";
        }
        if (dsaAlgorithmURIs.contains(algorithmURI)) {
            return "DSA";
        }
        if (ecdsaAlgorithmURIs.contains(algorithmURI)) {
            return "ECDSA";
        }
        return null;
    }

    public static Integer getKeyLength(String algorithmURI) {
        Logger log = AlgorithmSupport.getLogger();
        String algoClass = StringSupport.trimOrNull((String)JCEMapper.getAlgorithmClassFromURI((String)algorithmURI));
        if ("BlockEncryption".equals(algoClass) || "SymmetricKeyWrap".equals(algoClass)) {
            try {
                int keyLength = JCEMapper.getKeyLengthFromURI((String)algorithmURI);
                return new Integer(keyLength);
            }
            catch (NumberFormatException e) {
                log.warn("XML Security config contained invalid key length value for algorithm URI: " + algorithmURI);
            }
        }
        log.info("Mapping from algorithm URI {} to key length not available", (Object)algorithmURI);
        return null;
    }

    public static SecretKey generateSymmetricKey(String algoURI) throws NoSuchAlgorithmException, KeyException {
        Logger log = AlgorithmSupport.getLogger();
        String jceAlgorithmName = AlgorithmSupport.getKeyAlgorithm(algoURI);
        if (Strings.isNullOrEmpty((String)jceAlgorithmName)) {
            log.error("Mapping from algorithm URI '" + algoURI + "' to key algorithm not available, key generation failed");
            throw new NoSuchAlgorithmException("Algorithm URI'" + algoURI + "' is invalid for key generation");
        }
        Integer keyLength = AlgorithmSupport.getKeyLength(algoURI);
        if (keyLength == null) {
            log.error("Key length could not be determined from algorithm URI, can't generate key");
            throw new KeyException("Key length not determinable from algorithm URI, could not generate new key");
        }
        KeyGenerator keyGenerator = KeyGenerator.getInstance(jceAlgorithmName);
        keyGenerator.init(keyLength);
        return keyGenerator.generateKey();
    }

    public static KeyPair generateKeyPair(String algoURI, int keyLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        String jceAlgorithmName = JCEMapper.getJCEKeyAlgorithmFromURI((String)algoURI);
        return KeySupport.generateKeyPair((String)jceAlgorithmName, (int)keyLength, null);
    }

    public static Credential generateSymmetricKeyAndCredential(String algorithmURI) throws NoSuchAlgorithmException, KeyException {
        SecretKey key = AlgorithmSupport.generateSymmetricKey(algorithmURI);
        BasicCredential credential = new BasicCredential(key);
        return credential;
    }

    public static Credential generateKeyPairAndCredential(String algorithmURI, int keyLength, boolean includePrivate) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair keyPair = AlgorithmSupport.generateKeyPair(algorithmURI, keyLength);
        BasicCredential credential = new BasicCredential(keyPair.getPublic());
        if (includePrivate) {
            credential.setPrivateKey(keyPair.getPrivate());
        }
        return credential;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AlgorithmSupport.class);
    }

    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
        dsaAlgorithmURIs = new LazySet();
        dsaAlgorithmURIs.add("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        ecdsaAlgorithmURIs = new LazySet();
        ecdsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        rsaAlgorithmURIs = new HashSet<String>(10);
        rsaAlgorithmURIs.add("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        rsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        rsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384");
        rsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        rsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
        rsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160");
        rsaAlgorithmURIs.add("http://www.w3.org/2001/04/xmldsig-more#rsa-md5");
    }
}

