/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.util.storage;

import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.opensaml.util.storage.ReplayCacheEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ReplayCache {
    private final Logger log = LoggerFactory.getLogger(ReplayCache.class);
    private Map<String, ReplayCacheEntry> storage;
    private long entryDuration;
    private ReentrantLock cacheLock;

    public ReplayCache(Map<String, ReplayCacheEntry> cacheStorage, long duration) {
        this.storage = cacheStorage;
        this.entryDuration = duration;
        this.cacheLock = new ReentrantLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReplay(String issuerId, String messageId) {
        this.log.debug("Attempting to acquire lock for replay cache check");
        this.cacheLock.lock();
        this.log.debug("Lock acquired");
        try {
            boolean replayed = true;
            String entryHash = issuerId + messageId;
            ReplayCacheEntry cacheEntry = this.storage.get(entryHash);
            if (cacheEntry == null || cacheEntry.isExpired()) {
                if (this.log.isDebugEnabled()) {
                    if (cacheEntry == null) {
                        this.log.debug("Message ID {} was not a replay", (Object)messageId);
                    } else if (cacheEntry.isExpired()) {
                        this.log.debug("Message ID {} expired in replay cache at {}", (Object)messageId, (Object)cacheEntry.getExpirationTime().toString());
                        this.storage.remove(entryHash);
                    }
                }
                replayed = false;
                this.addMessageID(entryHash, new DateTime().plus(this.entryDuration));
            } else {
                this.log.debug("Replay of message ID {} detected in replay cache, will expire at {}", (Object)messageId, (Object)cacheEntry.getExpirationTime().toString());
            }
            boolean bl = replayed;
            return bl;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    protected void addMessageID(String messageId, DateTime expiration) {
        this.log.debug("Writing message ID {} to replay cache with expiration time {}", (Object)messageId, (Object)expiration.toString());
        this.storage.put(messageId, new ReplayCacheEntry(messageId, expiration));
    }
}

