/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.AbstractResource;
import net.shibboleth.utilities.java.support.resource.ResourceException;

public class ClasspathResource
extends AbstractResource {
    private final URL classpathResource;

    public ClasspathResource(String resourcePath) {
        this(resourcePath, ClasspathResource.class.getClassLoader());
    }

    public ClasspathResource(String resourcePath, ClassLoader classLoader) {
        String myLocation = Constraint.isNotNull(StringSupport.trimOrNull(resourcePath), "Resource path may not be null or empty");
        this.setLocation(myLocation);
        Constraint.isNotNull(classLoader, "Resource class loader may not be null");
        this.classpathResource = Constraint.isNotNull(classLoader.getResource(myLocation), "Resource " + resourcePath + " does not exist on the classpath");
    }

    @Override
    protected boolean doExists() throws ResourceException {
        return true;
    }

    @Override
    protected InputStream doGetInputStream() throws ResourceException {
        try {
            return this.classpathResource.openStream();
        }
        catch (IOException e) {
            throw new ResourceException("Resource " + this.getLocation() + " can not be read", e);
        }
    }

    @Override
    protected long doGetLastModifiedTime() throws ResourceException {
        return 0L;
    }
}

