/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.resource;

import com.google.common.base.Objects;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractDestructableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.ComponentValidationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.resource.ResourceException;

public abstract class AbstractResource
extends AbstractDestructableInitializableComponent
implements Resource {
    private String location;

    @Override
    public final void validate() throws ComponentValidationException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        this.doValidate();
    }

    @Override
    @Nonnull
    public final boolean exists() throws ResourceException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        return this.doExists();
    }

    @Override
    @Nonnull
    public final InputStream getInputStream() throws ResourceException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        return this.doGetInputStream();
    }

    @Override
    @Nonnull
    public final long getLastModifiedTime() throws ResourceException {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        return this.doGetLastModifiedTime();
    }

    @Override
    @Nonnull
    public final String getLocation() {
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        return this.location;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof Resource) {
            return this.getClass().equals(obj.getClass()) && Objects.equal((Object)this.location, (Object)((Resource)obj).getLocation());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getClass(), this.location});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("location", (Object)this.location).toString();
    }

    protected void setLocation(@Nullable String resourceLocation) {
        this.location = StringSupport.trimOrNull(resourceLocation);
    }

    protected void doValidate() throws ComponentValidationException {
        try {
            if (!this.exists()) {
                throw new ComponentValidationException(this.toString() + " does not exist");
            }
        }
        catch (ResourceException e) {
            throw new ComponentValidationException(e);
        }
    }

    @Nonnull
    protected abstract boolean doExists() throws ResourceException;

    @Nonnull
    protected abstract InputStream doGetInputStream() throws ResourceException;

    @Nonnull
    protected abstract long doGetLastModifiedTime() throws ResourceException;
}

