/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.HeapResourceFactory;

public class InMemoryCachingHttpClientBuilder {
    private final HttpClientBuilder clientBuilder;
    private int maxCacheEntries;
    private int maxCacheEntrySize;

    public InMemoryCachingHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        this.clientBuilder = Constraint.isNotNull(builder, "HttpClient builder can not be null");
        this.maxCacheEntries = 50;
        this.maxCacheEntrySize = 0x100000;
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxEntries) {
        this.maxCacheEntries = (int)Constraint.isGreaterThan(0L, maxEntries, "Maximum number of cache entries must be greater than 0");
    }

    public int getMaxCacheEntrySize() {
        return this.maxCacheEntrySize;
    }

    public void setMaxCacheEntrySize(int size) {
        this.maxCacheEntrySize = (int)Constraint.isGreaterThan(0L, size, "Maximum cache entry size must be greater than 0");
    }

    public HttpClient buildClient() {
        HttpClient client = this.clientBuilder.buildClient();
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setMaxCacheEntries(this.maxCacheEntries);
        cacheConfig.setMaxObjectSizeBytes(this.maxCacheEntrySize);
        cacheConfig.setHeuristicCachingEnabled(false);
        cacheConfig.setSharedCache(false);
        return new CachingHttpClient(client, (ResourceFactory)new HeapResourceFactory(), (HttpCacheStorage)new BasicHttpCacheStorage(cacheConfig), cacheConfig);
    }
}

