/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.utilities.java.support.httpclient.RequestConnectionClose;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;

public class HttpClientBuilder {
    private InetAddress socketLocalAddress;
    private int socketTimeout;
    private int socketBufferSize;
    private int connectionTimeout;
    private boolean connectionDisregardSslCertificate;
    private boolean connectionCloseAfterResponse;
    private boolean connectionStalecheck;
    private int connectionsMaxTotal;
    private int connectionsMaxPerRoute;
    private String connectionProxyHost;
    private int connectionProxyPort;
    private String connectionProxyUsername;
    private String connectionProxyPassword;
    private boolean httpFollowRedirects;
    private String httpContentCharSet;

    public HttpClientBuilder() {
        this.resetDefaults();
    }

    public void resetDefaults() {
        this.socketLocalAddress = null;
        this.socketTimeout = 5000;
        this.socketBufferSize = 8192;
        this.connectionTimeout = 5000;
        this.connectionDisregardSslCertificate = false;
        this.connectionCloseAfterResponse = true;
        this.connectionStalecheck = false;
        this.connectionsMaxTotal = 20;
        this.connectionsMaxPerRoute = 2;
        this.connectionProxyHost = null;
        this.connectionProxyPort = 8080;
        this.connectionProxyUsername = null;
        this.connectionProxyPassword = null;
        this.httpFollowRedirects = true;
        this.httpContentCharSet = "UTF-8";
    }

    public InetAddress getSocketLocalAddress() {
        return this.socketLocalAddress;
    }

    public void setSocketLocalAddress(InetAddress address) {
        this.socketLocalAddress = address;
    }

    public void setSocketLocalAddress(String ipOrHost) throws UnknownHostException {
        this.socketLocalAddress = InetAddress.getByName(Constraint.isNotNull(ipOrHost, "IP or hostname may not be null"));
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int size) {
        this.socketBufferSize = (int)Constraint.isGreaterThan(0L, size, "Socket buffer size must be greater than 0");
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public boolean isConnectionDisregardSslCertificate() {
        return this.connectionDisregardSslCertificate;
    }

    public void setConnectionDisregardSslCertificate(boolean disregard) {
        this.connectionDisregardSslCertificate = disregard;
    }

    public boolean isConnectionCloseAfterResponse() {
        return this.connectionCloseAfterResponse;
    }

    public void setConnectionCloseAfterResponse(boolean close) {
        this.connectionCloseAfterResponse = close;
    }

    public boolean isConnectionStalecheck() {
        return this.connectionStalecheck;
    }

    public void setConnectionStalecheck(boolean check) {
        this.connectionStalecheck = check;
    }

    public int getConnectionsMaxTotal() {
        return this.connectionsMaxTotal;
    }

    public void setConnectionsMaxTotal(int max) {
        this.connectionsMaxTotal = (int)Constraint.isGreaterThan(0L, max, "Max total connections must be greater than 0");
    }

    public int getConnectionsMaxPerRoute() {
        return this.connectionsMaxPerRoute;
    }

    public void setConnectionsMaxPerRoute(int max) {
        this.connectionsMaxPerRoute = (int)Constraint.isGreaterThan(0L, max, "Max connections per route must be greater than zero");
    }

    public String getConnectionProxyHost() {
        return this.connectionProxyHost;
    }

    public void setConnectionProxyHost(String host) {
        this.connectionProxyHost = StringSupport.trimOrNull(host);
    }

    public int getConnectionProxyPort() {
        return this.connectionProxyPort;
    }

    public void setConnectionProxyPort(int port) {
        this.connectionProxyPort = (int)Constraint.numberInRangeExclusive(0L, 65536L, port, "Proxy port must be between 0 and 65536, exclusive");
    }

    public String getConnectionProxyUsername() {
        return this.connectionProxyUsername;
    }

    public void setConnectionProxyUsername(String usename) {
        this.connectionProxyUsername = usename;
    }

    public String getConnectionProxyPassword() {
        return this.connectionProxyPassword;
    }

    public void setConnectionProxyPassword(String password) {
        this.connectionProxyPassword = password;
    }

    public boolean isHttpFollowRedirects() {
        return this.httpFollowRedirects;
    }

    public void setHttpFollowRedirects(boolean followRedirects) {
        this.httpFollowRedirects = followRedirects;
    }

    public String getHttpContentCharSet() {
        return this.httpContentCharSet;
    }

    public void setHttpContentCharSet(String charSet) {
        this.httpContentCharSet = charSet;
    }

    public HttpClient buildClient() {
        DefaultHttpClient client = new DefaultHttpClient(this.buildConnectionManager());
        client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
        if (this.connectionCloseAfterResponse) {
            client.addRequestInterceptor((HttpRequestInterceptor)new RequestConnectionClose());
        }
        client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
        HttpParams httpParams = client.getParams();
        if (this.socketLocalAddress != null) {
            httpParams.setParameter("http.route.local-address", (Object)this.socketLocalAddress);
        }
        if (this.socketTimeout > 0) {
            httpParams.setIntParameter("http.socket.timeout", this.socketTimeout);
        }
        httpParams.setIntParameter("http.socket.buffer-size", this.socketBufferSize);
        if (this.connectionTimeout > 0) {
            httpParams.setIntParameter("http.connection.timeout", this.connectionTimeout);
        }
        httpParams.setBooleanParameter("http.connection.stalecheck", this.connectionStalecheck);
        if (this.connectionProxyHost != null) {
            HttpHost proxyHost = new HttpHost(this.connectionProxyHost, this.connectionProxyPort);
            httpParams.setParameter("http.route.default-proxy", (Object)proxyHost);
            if (this.connectionProxyUsername != null && this.connectionProxyPassword != null) {
                CredentialsProvider credProvider = client.getCredentialsProvider();
                credProvider.setCredentials(new AuthScope(this.connectionProxyHost, this.connectionProxyPort), (Credentials)new UsernamePasswordCredentials(this.connectionProxyUsername, this.connectionProxyPassword));
            }
        }
        httpParams.setBooleanParameter("http.protocol.handle-redirects", this.httpFollowRedirects);
        httpParams.setParameter("http.protocol.content-charset", (Object)this.httpContentCharSet);
        return client;
    }

    private ClientConnectionManager buildConnectionManager() {
        SchemeRegistry registry = this.buildSchemeRegistry();
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager(registry);
        manager.setDefaultMaxPerRoute(this.connectionsMaxPerRoute);
        manager.setMaxTotal(this.connectionsMaxTotal);
        return manager;
    }

    private SchemeRegistry buildSchemeRegistry() {
        SSLSocketFactory sslSF;
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        if (!this.connectionDisregardSslCertificate) {
            sslSF = SSLSocketFactory.getSocketFactory();
        } else {
            X509TrustManager noTrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            };
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, new TrustManager[]{noTrustManager}, null);
                sslSF = new SSLSocketFactory(sslcontext);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("TLS SSLContext type is required to be supported by the JVM but is not", e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException("Some how the trust everything trust manager didn't trust everything", e);
            }
        }
        registry.register(new Scheme("https", 443, (SchemeSocketFactory)sslSF));
        return registry;
    }
}

