/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.client.HttpClient;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClient;
import org.apache.http.impl.client.cache.FileResourceFactory;
import org.apache.http.impl.client.cache.ManagedHttpCacheStorage;

public class FileCachingHttpClientBuilder {
    private final HttpClientBuilder clientBuilder;
    private File cacheDir;
    private int maxCacheEntries;
    private int maxCacheEntrySize;

    public FileCachingHttpClientBuilder(@Nonnull HttpClientBuilder builder) {
        this.clientBuilder = Constraint.isNotNull(builder, "HttpClient builder can not be null");
        this.cacheDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "wwwcache");
        this.maxCacheEntries = 100;
        this.maxCacheEntrySize = 0xA00000;
    }

    public File getCacheDirectory() {
        return this.cacheDir;
    }

    public void setCacheDirectory(@Nonnull @NotEmpty String directoryPath) {
        String trimmedPath = Constraint.isNotNull(StringSupport.trimOrNull(directoryPath), "Cache directory path can not be null or empty");
        this.cacheDir = new File(trimmedPath);
    }

    public void setCacheDirectory(@Nonnull File directory) {
        this.cacheDir = Constraint.isNotNull(directory, "Cache directory can not be null");
    }

    public int getMaxCacheEntries() {
        return this.maxCacheEntries;
    }

    public void setMaxCacheEntries(int maxEntries) {
        this.maxCacheEntries = (int)Constraint.isGreaterThan(0L, maxEntries, "Maximum number of cache entries must be greater than 0");
    }

    public int getMaxCacheEntrySize() {
        return this.maxCacheEntrySize;
    }

    public void setMaxCacheEntrySize(int size) {
        this.maxCacheEntrySize = (int)Constraint.isGreaterThan(0L, size, "Maximum cache entry size must be greater than 0");
    }

    public HttpClient buildClient() throws IOException {
        if (!this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            throw new IOException("Unable to create cache directory " + this.cacheDir.getAbsolutePath());
        }
        if (!this.cacheDir.canRead()) {
            throw new IOException("Cache directory '" + this.cacheDir.getAbsolutePath() + "' is not readable");
        }
        if (!this.cacheDir.canWrite()) {
            throw new IOException("Cache directory '" + this.cacheDir.getAbsolutePath() + "' is not writable");
        }
        HttpClient client = this.clientBuilder.buildClient();
        CacheConfig cacheConfig = new CacheConfig();
        cacheConfig.setMaxCacheEntries(this.maxCacheEntries);
        cacheConfig.setMaxObjectSizeBytes(this.maxCacheEntrySize);
        cacheConfig.setHeuristicCachingEnabled(false);
        cacheConfig.setSharedCache(false);
        return new CachingHttpClient(client, (ResourceFactory)new FileResourceFactory(this.cacheDir), (HttpCacheStorage)new ManagedHttpCacheStorage(cacheConfig), cacheConfig);
    }
}

