/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact;

import java.util.Map;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.BasicSAMLArtifactMapEntryFactory;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSAMLArtifactMap
implements SAMLArtifactMap {
    private final Logger log = LoggerFactory.getLogger(BasicSAMLArtifactMap.class);
    private Map<String, SAMLArtifactMap.SAMLArtifactMapEntry> artifactStore;
    private long artifactLifetime;
    private SAMLArtifactMap.SAMLArtifactMapEntryFactory entryFactory;

    public BasicSAMLArtifactMap(Map<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, long lifetime) {
        this(new BasicSAMLArtifactMapEntryFactory(), storage, lifetime);
    }

    public BasicSAMLArtifactMap(SAMLArtifactMap.SAMLArtifactMapEntryFactory factory, Map<String, SAMLArtifactMap.SAMLArtifactMapEntry> storage, long lifetime) {
        this.entryFactory = factory;
        this.artifactStore = storage;
        this.artifactLifetime = lifetime;
    }

    @Override
    public boolean contains(String artifact) {
        return this.artifactStore.containsKey(artifact);
    }

    @Override
    public SAMLArtifactMap.SAMLArtifactMapEntry get(String artifact) {
        this.log.debug("Attempting to retrieve entry for artifact: {}", (Object)artifact);
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactStore.get(artifact);
        if (entry == null) {
            this.log.debug("No entry found for artifact: {}", (Object)artifact);
            return null;
        }
        if (entry.isExpired()) {
            this.log.debug("Entry for artifact was expired: {}", (Object)artifact);
            this.remove(artifact);
            return null;
        }
        this.log.debug("Found valid entry for artifact: {}", (Object)artifact);
        return entry;
    }

    @Override
    public void put(String artifact, String relyingPartyId, String issuerId, SAMLObject samlMessage) throws MarshallingException {
        SAMLArtifactMap.SAMLArtifactMapEntry artifactEntry = this.entryFactory.newEntry(artifact, issuerId, relyingPartyId, samlMessage, this.artifactLifetime);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Storing new artifact entry '{}' for relying party '{}', expiring at '{}'", new Object[]{artifact, relyingPartyId, artifactEntry.getExpirationTime()});
        }
        this.artifactStore.put(artifact, artifactEntry);
    }

    @Override
    public void remove(String artifact) {
        this.log.debug("Removing artifact entry: {}", (Object)artifact);
        this.artifactStore.remove(artifact);
    }
}

