/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.security.provider;

import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTrustEngineRule<TokenType>
implements SecurityPolicyRule {
    private final Logger log = LoggerFactory.getLogger(BaseTrustEngineRule.class);
    private TrustEngine<TokenType> trustEngine;

    public BaseTrustEngineRule(TrustEngine<TokenType> engine) {
        this.trustEngine = engine;
    }

    protected TrustEngine<TokenType> getTrustEngine() {
        return this.trustEngine;
    }

    protected abstract CriteriaSet buildCriteriaSet(String var1, MessageContext var2) throws SecurityPolicyException;

    protected boolean evaluate(TokenType token, String entityID, MessageContext messageContext) throws SecurityPolicyException {
        CriteriaSet criteriaSet = this.buildCriteriaSet(entityID, messageContext);
        if (criteriaSet == null) {
            this.log.error("Returned criteria set was null, can not perform trust engine evaluation of token");
            throw new SecurityPolicyException("Returned criteria set was null");
        }
        return this.evaluate(token, criteriaSet);
    }

    protected boolean evaluate(TokenType token, CriteriaSet criteriaSet) throws SecurityPolicyException {
        try {
            return this.getTrustEngine().validate(token, criteriaSet);
        }
        catch (SecurityException e) {
            this.log.error("There was an error evaluating the request's token using the trust engine", (Throwable)e);
            throw new SecurityPolicyException("Error during trust engine evaluation of the token", (Exception)((Object)e));
        }
    }
}

