/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.message.handler;

import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.security.SecurityException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.BaseMessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.handler.HandlerChain;
import org.opensaml.ws.message.handler.HandlerChainAware;
import org.opensaml.ws.message.handler.HandlerChainResolver;
import org.opensaml.ws.message.handler.HandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHandlerChainAwareMessageDecoder
extends BaseMessageDecoder
implements HandlerChainAware {
    private final Logger log = LoggerFactory.getLogger(BaseHandlerChainAwareMessageDecoder.class);

    public BaseHandlerChainAwareMessageDecoder() {
    }

    public BaseHandlerChainAwareMessageDecoder(ParserPool pool) {
        super(pool);
    }

    @Override
    public void decode(MessageContext messageContext) throws MessageDecodingException, SecurityException {
        this.log.debug("Beginning to decode message from inbound transport of type: {}", (Object)messageContext.getInboundMessageTransport().getClass().getName());
        this.doDecode(messageContext);
        this.logDecodedMessage(messageContext);
        this.processPreSecurityInboundHandlerChain(messageContext);
        this.log.debug("Successfully processed pre-SecurityPolicy inbound handler chain.");
        this.processSecurityPolicy(messageContext);
        this.processPostSecurityInboundHandlerChain(messageContext);
        this.log.debug("Successfully processed post-SecurityPolicy inbound handler chain.");
        this.log.debug("Successfully decoded message.");
    }

    protected void processPreSecurityInboundHandlerChain(MessageContext messageContext) throws MessageDecodingException {
        HandlerChainResolver inboundHandlerChainResolver = messageContext.getPreSecurityInboundHandlerChainResolver();
        if (inboundHandlerChainResolver != null) {
            this.log.debug("Invoking pre-SecurityPolicy inbound handler chain on message context");
            try {
                for (HandlerChain inboundHandlerChain : inboundHandlerChainResolver.resolve(messageContext)) {
                    if (inboundHandlerChain == null) continue;
                    this.invokeHandlerChain(inboundHandlerChain, messageContext);
                }
            }
            catch (HandlerException e) {
                this.log.error("Encountered pre-SecurityPolicy HandlerException when decoding message: {}", (Object)e.getMessage());
                throw new MessageDecodingException("Pre-SecurityPolicy Handler exception while decoding message", e);
            }
        }
    }

    protected void processPostSecurityInboundHandlerChain(MessageContext messageContext) throws MessageDecodingException {
        HandlerChainResolver inboundHandlerChainResolver = messageContext.getPostSecurityInboundHandlerChainResolver();
        if (inboundHandlerChainResolver != null) {
            this.log.debug("Invoking post-SecurityPolicy inbound handler chain on message context");
            try {
                for (HandlerChain inboundHandlerChain : inboundHandlerChainResolver.resolve(messageContext)) {
                    if (inboundHandlerChain == null) continue;
                    this.invokeHandlerChain(inboundHandlerChain, messageContext);
                }
            }
            catch (HandlerException e) {
                this.log.error("Encountered post-SecurityPolicy HandlerException when decoding message: {}", (Object)e.getMessage());
                throw new MessageDecodingException("Handler exception while decoding message", e);
            }
        }
    }

    protected void invokeHandlerChain(HandlerChain handlerChain, MessageContext messageContext) throws HandlerException {
        if (handlerChain != null && messageContext != null) {
            handlerChain.invoke(messageContext);
        }
    }
}

