/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.encoder.servlet;

import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.encoder.servlet.AbstractHttpServletResponseMessageEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseHttpServletResponseXmlMessageEncoder<MessageType extends XMLObject>
extends AbstractHttpServletResponseMessageEncoder<MessageType> {
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    private final Logger log = LoggerFactory.getLogger(BaseHttpServletResponseXmlMessageEncoder.class);

    @Override
    public void encode() throws MessageEncodingException {
        this.log.debug("Beginning encode of message of type: {}", (Object)((XMLObject)this.getMessageContext().getMessage()).getClass().getName());
        super.encode();
        this.logEncodedMessage();
        this.log.debug("Successfully encoded message.");
    }

    protected void logEncodedMessage() {
        if (this.protocolMessageLog.isDebugEnabled()) {
            MessageContext messageContext = this.getMessageContext();
            if (messageContext.getMessage() == null) {
                this.log.warn("Encoded message was null, nothing to log");
                return;
            }
            if (!(messageContext.getMessage() instanceof XMLObject)) {
                this.log.warn("Encoded message was not an instance of XMLObject, was a: {}", (Object)messageContext.getMessage().getClass().getName());
                return;
            }
            XMLObject message = (XMLObject)messageContext.getMessage();
            try {
                Element dom = XMLObjectSupport.marshall((XMLObject)message);
                this.protocolMessageLog.debug("\n" + SerializeSupport.prettyPrintXML((Node)dom));
            }
            catch (MarshallingException e) {
                this.log.error("Unable to marshall message for logging purposes", (Throwable)e);
            }
        }
    }

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        this.log.debug("Marshalling message");
        try {
            return XMLObjectSupport.marshall((XMLObject)message);
        }
        catch (MarshallingException e) {
            this.log.error("Error marshalling message", (Throwable)e);
            throw new MessageEncodingException("Error marshalling message", (Exception)((Object)e));
        }
    }
}

