/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.UUID;
import net.shibboleth.utilities.java.support.collection.ClassIndexedSet;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.MessageRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContext
implements IdentifiableComponent,
Iterable<BaseContext> {
    private final Logger log = LoggerFactory.getLogger(BaseContext.class);
    private BaseContext parent;
    private ClassIndexedSet<BaseContext> subcontexts = new ClassIndexedSet();
    private String id;
    private DateTime creationTime = new DateTime();
    private boolean autoCreateSubcontexts;

    public BaseContext() {
        this.setAutoCreateSubcontexts(false);
        this.setId(UUID.randomUUID().toString());
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String newId) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newId), (String)"Context ID can not be null or empty");
    }

    public DateTime getCreationTime() {
        return this.creationTime;
    }

    public BaseContext getParent() {
        return this.parent;
    }

    protected void setParent(BaseContext newParent) {
        this.parent = newParent;
    }

    public <T extends BaseContext> T getSubcontext(Class<T> clazz) {
        return this.getSubcontext(clazz, this.isAutoCreateSubcontexts());
    }

    public <T extends BaseContext> T getSubcontext(Class<T> clazz, boolean autocreate) {
        this.log.trace("Request for subcontext of type: {}", (Object)clazz.getName());
        BaseContext subcontext = (BaseContext)this.subcontexts.get(clazz);
        if (subcontext != null) {
            this.log.trace("Subcontext found of type: {}", (Object)clazz.getName());
            return (T)subcontext;
        }
        if (autocreate) {
            this.log.trace("Subcontext not found of type, autocreating: {}", (Object)clazz.getName());
            subcontext = this.createSubcontext(clazz);
            this.addSubcontext(subcontext);
            return (T)subcontext;
        }
        this.log.trace("Subcontext not found of type: {}", (Object)clazz.getName());
        return null;
    }

    public void addSubcontext(BaseContext subContext) {
        this.addSubcontext(subContext, false);
    }

    public void addSubcontext(BaseContext subcontext, boolean replace) {
        BaseContext existing = (BaseContext)this.subcontexts.get(subcontext.getClass());
        if (existing == subcontext) {
            this.log.trace("Subcontext to add was already a child of the current context, skipping");
            return;
        }
        this.log.trace("Attempting to store a subcontext with type '{}' id '{}' with replace option '{}'", (Object[])new String[]{subcontext.getClass().getName(), subcontext.getId(), new Boolean(replace).toString()});
        this.subcontexts.add((Object)subcontext, replace);
        BaseContext oldParent = subcontext.getParent();
        if (oldParent != null && oldParent != this) {
            this.log.trace("New subcontext with type '{}' id '{}' is currently a subcontext of parent with type '{}' id '{}', removing it", (Object[])new String[]{subcontext.getClass().getName(), subcontext.getId(), oldParent.getClass().getName(), oldParent.getId()});
            subcontext.getParent().removeSubcontext(subcontext);
        }
        this.log.trace("New subcontext with type '{}' id '{}' is set to have parent with type '{}' id '{}', removing it", (Object[])new String[]{subcontext.getClass().getName(), subcontext.getId(), this.getClass().getName(), this.getId()});
        subcontext.setParent(this);
        if (existing != null) {
            this.log.trace("Old subcontext with type '{}' id '{}' will have parent cleared", (Object[])new String[]{existing.getClass().getName(), existing.getId()});
            existing.setParent(null);
        }
    }

    public void removeSubcontext(BaseContext subcontext) {
        this.log.trace("Removing subcontext with type '{}' id '{}' from parent with type '{}' id '{}'", (Object[])new String[]{subcontext.getClass().getName(), subcontext.getId(), this.getClass().getName(), this.getId()});
        subcontext.setParent(null);
        this.subcontexts.remove((Object)subcontext);
    }

    public <T extends BaseContext> void removeSubcontext(Class<T> clazz) {
        T subcontext = this.getSubcontext(clazz, false);
        if (subcontext != null) {
            this.removeSubcontext((BaseContext)subcontext);
        }
    }

    public <T extends BaseContext> boolean containsSubcontext(Class<T> clazz) {
        return this.subcontexts.contains(clazz);
    }

    public void clearSubcontexts() {
        this.log.trace("Clearing all subcontexts from context with type '{}' id '{}'", (Object)this.getClass().getName(), (Object)this.getId());
        for (BaseContext subcontext : this.subcontexts) {
            subcontext.setParent(null);
        }
        this.subcontexts.clear();
    }

    public boolean isAutoCreateSubcontexts() {
        return this.autoCreateSubcontexts;
    }

    public void setAutoCreateSubcontexts(boolean autoCreate) {
        this.autoCreateSubcontexts = autoCreate;
    }

    @Override
    public Iterator<BaseContext> iterator() {
        return new ContextSetNoRemoveIteratorDecorator(this.subcontexts.iterator());
    }

    protected <T extends BaseContext> T createSubcontext(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getConstructor(new Class[0]);
            return (T)((BaseContext)constructor.newInstance(new Object[0]));
        }
        catch (SecurityException e) {
            this.log.error("Security error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (NoSuchMethodException e) {
            this.log.error("No such method error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Illegal argument error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (InstantiationException e) {
            this.log.error("Instantiation error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (IllegalAccessException e) {
            this.log.error("Illegal access error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
        catch (InvocationTargetException e) {
            this.log.error("Invocation target error on creating subcontext", (Throwable)e);
            throw new MessageRuntimeException("Error creating subcontext", e);
        }
    }

    protected class ContextSetNoRemoveIteratorDecorator
    implements Iterator<BaseContext> {
        private Iterator<BaseContext> wrappedIterator;

        protected ContextSetNoRemoveIteratorDecorator(Iterator<BaseContext> iterator) {
            this.wrappedIterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public BaseContext next() {
            return this.wrappedIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removal of subcontexts via the iterator is unsupported");
        }
    }
}

