/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.trust.TrustedCredentialTrustEngine;
import org.opensaml.security.trust.impl.ExplicitKeyTrustEvaluator;
import org.opensaml.xmlsec.crypto.AlgorithmSupport;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.impl.BaseSignatureTrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplicitKeySignatureTrustEngine
extends BaseSignatureTrustEngine<Iterable<Credential>>
implements TrustedCredentialTrustEngine<Signature> {
    private final Logger log = LoggerFactory.getLogger(ExplicitKeySignatureTrustEngine.class);
    private CredentialResolver credentialResolver;
    private ExplicitKeyTrustEvaluator keyTrust;

    public ExplicitKeySignatureTrustEngine(CredentialResolver resolver, KeyInfoCredentialResolver keyInfoResolver) {
        super(keyInfoResolver);
        if (resolver == null) {
            throw new IllegalArgumentException("Credential resolver may not be null");
        }
        this.credentialResolver = resolver;
        this.keyTrust = new ExplicitKeyTrustEvaluator();
    }

    public CredentialResolver getCredentialResolver() {
        return this.credentialResolver;
    }

    @Override
    public boolean validate(Signature signature, CriteriaSet trustBasisCriteria) throws SecurityException {
        Iterable trustedCredentials;
        String jcaAlgorithm;
        this.checkParams(signature, trustBasisCriteria);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.addAll((Collection)trustBasisCriteria);
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        if (!Strings.isNullOrEmpty((String)(jcaAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)signature.getSignatureAlgorithm())))) {
            criteriaSet.add((Object)new KeyAlgorithmCriterion(jcaAlgorithm), true);
        }
        try {
            trustedCredentials = this.getCredentialResolver().resolve((Object)criteriaSet);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted credentials", (Exception)((Object)e));
        }
        if (this.validate(signature, trustedCredentials)) {
            return true;
        }
        this.log.debug("Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            if (!this.verifySignature(signature, trustedCredential)) continue;
            this.log.debug("Successfully verified signature using resolved trusted credential");
            return true;
        }
        this.log.debug("Failed to verify signature using either KeyInfo-derived or directly trusted credentials");
        return false;
    }

    public boolean validate(byte[] signature, byte[] content, String algorithmURI, CriteriaSet trustBasisCriteria, Credential candidateCredential) throws SecurityException {
        Iterable trustedCredentials;
        String jcaAlgorithm;
        this.checkParamsRaw(signature, content, algorithmURI, trustBasisCriteria);
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.addAll((Collection)trustBasisCriteria);
        if (!criteriaSet.contains(UsageCriterion.class)) {
            criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        }
        if (!Strings.isNullOrEmpty((String)(jcaAlgorithm = AlgorithmSupport.getKeyAlgorithm((String)algorithmURI)))) {
            criteriaSet.add((Object)new KeyAlgorithmCriterion(jcaAlgorithm), true);
        }
        try {
            trustedCredentials = this.getCredentialResolver().resolve((Object)criteriaSet);
        }
        catch (ResolverException e) {
            throw new SecurityException("Error resolving trusted credentials", (Exception)((Object)e));
        }
        if (candidateCredential != null && XMLSigningUtil.verifyWithURI((Credential)candidateCredential, (String)algorithmURI, (byte[])signature, (byte[])content)) {
            this.log.debug("Successfully verified signature using supplied candidate credential");
            this.log.debug("Attempting to establish trust of supplied candidate credential");
            if (this.evaluateTrust(candidateCredential, trustedCredentials)) {
                this.log.debug("Successfully established trust of supplied candidate credential");
                return true;
            }
            this.log.debug("Failed to establish trust of supplied candidate credential");
        }
        this.log.debug("Attempting to verify signature using trusted credentials");
        for (Credential trustedCredential : trustedCredentials) {
            if (!XMLSigningUtil.verifyWithURI((Credential)trustedCredential, (String)algorithmURI, (byte[])signature, (byte[])content)) continue;
            this.log.debug("Successfully verified signature using resolved trusted credential");
            return true;
        }
        this.log.debug("Failed to verify signature using either supplied candidate credential or directly trusted credentials");
        return false;
    }

    @Override
    protected boolean evaluateTrust(Credential untrustedCredential, Iterable<Credential> trustedCredentials) throws SecurityException {
        return this.keyTrust.validate(untrustedCredential, trustedCredentials);
    }
}

