/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support;

import java.util.List;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Signer {
    protected Signer() {
    }

    public static void signObjects(List<Signature> xmlObjects) throws SignatureException {
        for (Signature xmlObject : xmlObjects) {
            Signer.signObject(xmlObject);
        }
    }

    public static void signObject(Signature signature) throws SignatureException {
        Logger log = Signer.getLogger();
        try {
            XMLSignature xmlSignature = ((SignatureImpl)signature).getXMLSignature();
            if (xmlSignature == null) {
                log.error("Unable to compute signature, Signature XMLObject does not have the XMLSignature created during marshalling.");
                throw new SignatureException("XMLObject does not have an XMLSignature instance, unable to compute signature");
            }
            log.debug("Computing signature over XMLSignature object");
            xmlSignature.sign(CredentialSupport.extractSigningKey((Credential)signature.getSigningCredential()));
        }
        catch (XMLSecurityException e) {
            log.error("An error occured computing the digital signature", (Throwable)e);
            throw new SignatureException("Signature computation error", (Exception)((Object)e));
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(Signer.class);
    }

    static {
        Logger log = Signer.getLogger();
        if (!Init.isInitialized()) {
            log.debug("Initializing XML security library");
            Init.init();
        }
    }
}

