/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl.provider;

import java.security.KeyException;
import java.security.PublicKey;
import java.util.Collection;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.criteria.KeyAlgorithmCriterion;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.opensaml.xmlsec.signature.KeyValue;
import org.opensaml.xmlsec.signature.RSAKeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAKeyValueProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(RSAKeyValueProvider.class);

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return this.getRSAKeyValue(keyInfoChild) != null;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CriteriaSet criteriaSet, KeyInfoResolutionContext kiContext) throws SecurityException {
        KeyInfoCredentialContext credContext;
        RSAKeyValue keyValue = this.getRSAKeyValue(keyInfoChild);
        if (keyValue == null) {
            return null;
        }
        KeyAlgorithmCriterion algorithmCriteria = (KeyAlgorithmCriterion)criteriaSet.get(KeyAlgorithmCriterion.class);
        if (algorithmCriteria != null && algorithmCriteria.getKeyAlgorithm() != null && !algorithmCriteria.getKeyAlgorithm().equals("RSA")) {
            this.log.debug("Criterion specified non-RSA key algorithm, skipping");
            return null;
        }
        this.log.debug("Attempting to extract credential from an RSAKeyValue");
        PublicKey pubKey = null;
        try {
            pubKey = KeyInfoSupport.getRSAKey((RSAKeyValue)keyValue);
        }
        catch (KeyException e) {
            this.log.error("Error extracting RSA key value", (Throwable)e);
            throw new SecurityException("Error extracting RSA key value", (Exception)e);
        }
        BasicCredential cred = new BasicCredential(pubKey);
        if (kiContext != null) {
            cred.getKeyNames().addAll(kiContext.getKeyNames());
        }
        if ((credContext = this.buildCredentialContext(kiContext)) != null) {
            cred.getCredentalContextSet().add((Object)credContext);
        }
        this.log.debug("Credential successfully extracted from RSAKeyValue");
        LazySet credentialSet = new LazySet();
        credentialSet.add((Object)cred);
        return credentialSet;
    }

    protected RSAKeyValue getRSAKeyValue(XMLObject xmlObject) {
        if (xmlObject == null) {
            return null;
        }
        if (xmlObject instanceof RSAKeyValue) {
            return (RSAKeyValue)xmlObject;
        }
        if (xmlObject instanceof KeyValue) {
            return ((KeyValue)xmlObject).getRSAKeyValue();
        }
        return null;
    }
}

