/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl.provider;

import com.google.common.base.Strings;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.InternalX500DNHandler;
import org.opensaml.security.x509.X500DNHandler;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoCredentialContext;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.opensaml.xmlsec.keyinfo.impl.provider.AbstractKeyInfoProvider;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.X509IssuerSerial;
import org.opensaml.xmlsec.signature.X509SKI;
import org.opensaml.xmlsec.signature.X509SubjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineX509DataProvider
extends AbstractKeyInfoProvider {
    private final Logger log = LoggerFactory.getLogger(InlineX509DataProvider.class);
    private X500DNHandler x500DNHandler = new InternalX500DNHandler();

    public X500DNHandler getX500DNHandler() {
        return this.x500DNHandler;
    }

    public void setX500DNHandler(X500DNHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("X500DNHandler may not be null");
        }
        this.x500DNHandler = handler;
    }

    @Override
    public boolean handles(XMLObject keyInfoChild) {
        return keyInfoChild instanceof X509Data;
    }

    @Override
    public Collection<Credential> process(KeyInfoCredentialResolver resolver, XMLObject keyInfoChild, CriteriaSet criteriaSet, KeyInfoResolutionContext kiContext) throws SecurityException {
        KeyInfoCredentialContext credContext;
        X509Certificate entityCert;
        if (!this.handles(keyInfoChild)) {
            return null;
        }
        X509Data x509Data = (X509Data)keyInfoChild;
        this.log.debug("Attempting to extract credential from an X509Data");
        List<X509Certificate> certs = this.extractCertificates(x509Data);
        if (certs.isEmpty()) {
            this.log.info("The X509Data contained no X509Certificate elements, skipping credential extraction");
            return null;
        }
        List<X509CRL> crls = this.extractCRLs(x509Data);
        PublicKey resolvedPublicKey = null;
        if (kiContext != null && kiContext.getKey() != null && kiContext.getKey() instanceof PublicKey) {
            resolvedPublicKey = (PublicKey)kiContext.getKey();
        }
        if ((entityCert = this.findEntityCert(certs, x509Data, resolvedPublicKey)) == null) {
            this.log.warn("The end-entity cert could not be identified, skipping credential extraction");
            return null;
        }
        BasicX509Credential cred = new BasicX509Credential(entityCert);
        cred.setCRLs(crls);
        cred.setEntityCertificateChain(certs);
        if (kiContext != null) {
            cred.getKeyNames().addAll(kiContext.getKeyNames());
        }
        if ((credContext = this.buildCredentialContext(kiContext)) != null) {
            cred.getCredentalContextSet().add((Object)credContext);
        }
        LazySet credentialSet = new LazySet();
        credentialSet.add((Object)cred);
        return credentialSet;
    }

    private List<X509CRL> extractCRLs(X509Data x509Data) throws SecurityException {
        List crls = null;
        try {
            crls = KeyInfoSupport.getCRLs((X509Data)x509Data);
        }
        catch (CRLException e) {
            this.log.error("Error extracting CRL's from X509Data", (Throwable)e);
            throw new SecurityException("Error extracting CRL's from X509Data", (Exception)e);
        }
        this.log.debug("Found {} X509CRLs", (Object)crls.size());
        return crls;
    }

    private List<X509Certificate> extractCertificates(X509Data x509Data) throws SecurityException {
        List certs = null;
        try {
            certs = KeyInfoSupport.getCertificates((X509Data)x509Data);
        }
        catch (CertificateException e) {
            this.log.error("Error extracting certificates from X509Data", (Throwable)e);
            throw new SecurityException("Error extracting certificates from X509Data", (Exception)e);
        }
        this.log.debug("Found {} X509Certificates", (Object)certs.size());
        return certs;
    }

    protected X509Certificate findEntityCert(List<X509Certificate> certs, X509Data x509Data, PublicKey resolvedKey) {
        if (certs == null || certs.isEmpty()) {
            return null;
        }
        if (certs.size() == 1) {
            this.log.debug("Single certificate was present, treating as end-entity certificate");
            return certs.get(0);
        }
        X509Certificate cert = null;
        cert = this.findCertFromKey(certs, resolvedKey);
        if (cert != null) {
            this.log.debug("End-entity certificate resolved by matching previously resolved public key");
            return cert;
        }
        cert = this.findCertFromSubjectNames(certs, x509Data.getX509SubjectNames());
        if (cert != null) {
            this.log.debug("End-entity certificate resolved by matching X509SubjectName");
            return cert;
        }
        cert = this.findCertFromIssuerSerials(certs, x509Data.getX509IssuerSerials());
        if (cert != null) {
            this.log.debug("End-entity certificate resolved by matching X509IssuerSerial");
            return cert;
        }
        cert = this.findCertFromSubjectKeyIdentifier(certs, x509Data.getX509SKIs());
        if (cert != null) {
            this.log.debug("End-entity certificate resolved by matching X509SKI");
            return cert;
        }
        this.log.debug("Treating the first certificate in the X509Data as the end-entity certificate");
        return certs.get(0);
    }

    protected X509Certificate findCertFromKey(List<X509Certificate> certs, PublicKey key) {
        if (key != null) {
            for (X509Certificate cert : certs) {
                if (!cert.getPublicKey().equals(key)) continue;
                return cert;
            }
        }
        return null;
    }

    protected X509Certificate findCertFromSubjectNames(List<X509Certificate> certs, List<X509SubjectName> names) {
        for (X509SubjectName subjectName : names) {
            if (Strings.isNullOrEmpty((String)subjectName.getValue())) continue;
            X500Principal subjectX500Principal = this.x500DNHandler.parse(subjectName.getValue());
            for (X509Certificate cert : certs) {
                if (!cert.getSubjectX500Principal().equals(subjectX500Principal)) continue;
                return cert;
            }
        }
        return null;
    }

    protected X509Certificate findCertFromIssuerSerials(List<X509Certificate> certs, List<X509IssuerSerial> serials) {
        for (X509IssuerSerial issuerSerial : serials) {
            if (issuerSerial.getX509IssuerName() == null || issuerSerial.getX509SerialNumber() == null) continue;
            String issuerNameValue = issuerSerial.getX509IssuerName().getValue();
            BigInteger serialNumber = issuerSerial.getX509SerialNumber().getValue();
            if (Strings.isNullOrEmpty((String)issuerNameValue)) continue;
            X500Principal issuerX500Principal = this.x500DNHandler.parse(issuerNameValue);
            for (X509Certificate cert : certs) {
                if (!cert.getIssuerX500Principal().equals(issuerX500Principal) || !cert.getSerialNumber().equals(serialNumber)) continue;
                return cert;
            }
        }
        return null;
    }

    protected X509Certificate findCertFromSubjectKeyIdentifier(List<X509Certificate> certs, List<X509SKI> skis) {
        for (X509SKI ski : skis) {
            if (Strings.isNullOrEmpty((String)ski.getValue())) continue;
            byte[] xmlValue = Base64Support.decode((String)ski.getValue());
            for (X509Certificate cert : certs) {
                byte[] certValue = X509Support.getSubjectKeyIdentifier((X509Certificate)cert);
                if (certValue == null || !Arrays.equals(xmlValue, certValue)) continue;
                return cert;
            }
        }
        return null;
    }
}

