/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.criteria.KeyNameCriterion;
import org.opensaml.security.criteria.PublicKeyCriterion;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;

public class LocalKeyInfoCredentialResolver
extends BasicProviderKeyInfoCredentialResolver {
    private CredentialResolver localCredResolver;

    public LocalKeyInfoCredentialResolver(List<KeyInfoProvider> keyInfoProviders, CredentialResolver localCredentialResolver) {
        super(keyInfoProviders);
        if (localCredentialResolver == null) {
            throw new IllegalArgumentException("Local credential resolver must be supplied");
        }
        this.localCredResolver = localCredentialResolver;
    }

    public CredentialResolver getLocalCredentialResolver() {
        return this.localCredResolver;
    }

    @Override
    protected void postProcess(KeyInfoResolutionContext kiContext, CriteriaSet criteriaSet, List<Credential> credentials) throws ResolverException {
        ArrayList<Object> localCreds = new ArrayList<Object>();
        for (Credential cred : credentials) {
            if (this.isLocalCredential(cred)) {
                localCreds.add(cred);
                continue;
            }
            if (cred.getPublicKey() == null) continue;
            localCreds.addAll(this.resolveByPublicKey(cred.getPublicKey()));
        }
        for (String keyName : kiContext.getKeyNames()) {
            localCreds.addAll(this.resolveByKeyName(keyName));
        }
        credentials.clear();
        credentials.addAll(localCreds);
    }

    protected boolean isLocalCredential(Credential credential) {
        return credential.getPrivateKey() != null || credential.getSecretKey() != null;
    }

    protected Collection<? extends Credential> resolveByKeyName(String keyName) throws ResolverException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyNameCriterion(keyName)});
        for (Credential cred : this.getLocalCredentialResolver().resolve((Object)criteriaSet)) {
            if (!this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }

    protected Collection<? extends Credential> resolveByPublicKey(PublicKey publicKey) throws ResolverException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new PublicKeyCriterion(publicKey)});
        for (Credential cred : this.getLocalCredentialResolver().resolve((Object)criteriaSet)) {
            if (!this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }
}

