/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config;

import java.util.ArrayList;
import org.opensaml.xmlsec.config.BasicSecurityConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.KeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.NamedKeyInfoGeneratorManager;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.keyinfo.impl.provider.DSAKeyValueProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.InlineX509DataProvider;
import org.opensaml.xmlsec.keyinfo.impl.provider.RSAKeyValueProvider;

public class DefaultSecurityConfigurationBootstrap {
    protected DefaultSecurityConfigurationBootstrap() {
    }

    public static BasicSecurityConfiguration buildDefaultConfig() {
        BasicSecurityConfiguration config = new BasicSecurityConfiguration();
        DefaultSecurityConfigurationBootstrap.populateSignatureParams(config);
        DefaultSecurityConfigurationBootstrap.populateEncryptionParams(config);
        DefaultSecurityConfigurationBootstrap.populateKeyInfoCredentialResolverParams(config);
        DefaultSecurityConfigurationBootstrap.populateKeyInfoGeneratorManager(config);
        DefaultSecurityConfigurationBootstrap.populateKeyParams(config);
        return config;
    }

    protected static void populateSignatureParams(BasicSecurityConfiguration config) {
        config.registerSignatureAlgorithmURI("RSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        config.registerSignatureAlgorithmURI("DSA", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        config.registerSignatureAlgorithmURI("ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1");
        config.registerSignatureAlgorithmURI("AES", "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        config.registerSignatureAlgorithmURI("DESede", "http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        config.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        config.setSignatureHMACOutputLength(null);
        config.setSignatureReferenceDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected static void populateEncryptionParams(BasicSecurityConfiguration config) {
        config.registerDataEncryptionAlgorithmURI("AES", 128, "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        config.registerDataEncryptionAlgorithmURI("AES", 192, "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        config.registerDataEncryptionAlgorithmURI("AES", 256, "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        config.registerDataEncryptionAlgorithmURI("DESede", 168, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        config.registerDataEncryptionAlgorithmURI("DESede", 192, "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        config.registerKeyTransportEncryptionAlgorithmURI("RSA", null, "AES", "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        config.registerKeyTransportEncryptionAlgorithmURI("RSA", null, "DESede", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        config.registerKeyTransportEncryptionAlgorithmURI("AES", 128, null, "http://www.w3.org/2001/04/xmlenc#kw-aes128");
        config.registerKeyTransportEncryptionAlgorithmURI("AES", 192, null, "http://www.w3.org/2001/04/xmlenc#kw-aes192");
        config.registerKeyTransportEncryptionAlgorithmURI("AES", 256, null, "http://www.w3.org/2001/04/xmlenc#kw-aes256");
        config.registerKeyTransportEncryptionAlgorithmURI("DESede", 168, null, "http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        config.registerKeyTransportEncryptionAlgorithmURI("DESede", 192, null, "http://www.w3.org/2001/04/xmlenc#kw-tripledes");
        config.setAutoGeneratedDataEncryptionKeyAlgorithmURI("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
    }

    protected static void populateKeyInfoCredentialResolverParams(BasicSecurityConfiguration config) {
        ArrayList<KeyInfoProvider> providers = new ArrayList<KeyInfoProvider>();
        providers.add(new RSAKeyValueProvider());
        providers.add(new DSAKeyValueProvider());
        providers.add(new InlineX509DataProvider());
        BasicProviderKeyInfoCredentialResolver resolver = new BasicProviderKeyInfoCredentialResolver(providers);
        config.setDefaultKeyInfoCredentialResolver(resolver);
    }

    protected static void populateKeyInfoGeneratorManager(BasicSecurityConfiguration config) {
        NamedKeyInfoGeneratorManager namedManager = new NamedKeyInfoGeneratorManager();
        config.setKeyInfoGeneratorManager(namedManager);
        namedManager.setUseDefaultManager(true);
        KeyInfoGeneratorManager defaultManager = namedManager.getDefaultManager();
        BasicKeyInfoGeneratorFactory basicFactory = new BasicKeyInfoGeneratorFactory();
        basicFactory.setEmitPublicKeyValue(true);
        X509KeyInfoGeneratorFactory x509Factory = new X509KeyInfoGeneratorFactory();
        x509Factory.setEmitEntityCertificate(true);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)basicFactory);
        defaultManager.registerFactory((KeyInfoGeneratorFactory)x509Factory);
    }

    protected static void populateKeyParams(BasicSecurityConfiguration config) {
    }
}

