/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.storagearea;

import it.grid.storm.storagearea.StorageArea;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAreaManager {
    private static final Logger log = LoggerFactory.getLogger(StorageAreaManager.class);
    private final String beHostname;
    private final int bePort;
    private List<StorageArea> storageAreas;
    private static StorageAreaManager SAManager = null;
    private HashMap<String, String> fsRootFromStfn;
    private HashMap<String, String> stfnRootFromFs;

    public static void init(String stormBEHostname, int stormBEPort) throws Exception {
        SAManager = new StorageAreaManager(stormBEHostname, stormBEPort);
    }

    public static boolean isInitialized() {
        return StorageAreaManager.getInstance() != null;
    }

    public static StorageAreaManager getInstance() {
        return SAManager;
    }

    public String getBeHostname() {
        return this.beHostname;
    }

    public int getBePort() {
        return this.bePort;
    }

    public List<StorageArea> getStorageAreas() {
        return this.storageAreas;
    }

    public HashMap<String, String> getStfnRootFromFs() {
        return this.stfnRootFromFs;
    }

    public HashMap<String, String> getFsRootFromStfn() {
        return this.fsRootFromStfn;
    }

    public static StorageArea getMatchingSA(File localFile) throws IllegalArgumentException, IllegalStateException {
        if (localFile == null) {
            log.error("Unable to match StorageArea, the provided localFile is null");
            throw new IllegalArgumentException("Provided localFile is null!");
        }
        if (!StorageAreaManager.isInitialized()) {
            log.error("Unable to match StorageArea, class not initialized. Call init() first");
            throw new IllegalStateException("Unable to match any StorageArea, class not initialized.");
        }
        String path = localFile.getPath();
        log.debug("Looking for a StorageArea that matches " + path);
        StorageArea mapped = null;
        for (StorageArea storageArea : StorageAreaManager.getInstance().getStorageAreas()) {
            if (!path.startsWith(storageArea.getFSRoot()) || mapped != null && storageArea.getFSRoot().length() <= mapped.getFSRoot().length()) continue;
            mapped = storageArea;
        }
        if (mapped == null) {
            log.debug("No match found");
        } else {
            log.debug("Matched StorageArea " + mapped.toString());
        }
        return mapped;
    }

    public static StorageArea getMatchingSA(URI uri) throws IllegalArgumentException, IllegalStateException {
        if (uri == null) {
            log.error("Unable to match StorageArea, the provided uri is null");
            throw new IllegalArgumentException("Provided uri is null!");
        }
        return StorageAreaManager.getMatchingSA(uri.getPath());
    }

    public static StorageArea getMatchingSA(String uriPath) throws IllegalArgumentException, IllegalStateException {
        if (uriPath == null) {
            log.error("Unable to match StorageArea, the provided uriPath is null");
            throw new IllegalArgumentException("Provided uriPath is null!");
        }
        if (!StorageAreaManager.isInitialized()) {
            log.error("Unable to match StorageArea, class not initialized. Call init() first");
            throw new IllegalStateException("Unable to match any StorageArea, class not initialized.");
        }
        log.debug("URI path = " + uriPath);
        StorageArea matched = null;
        log.debug("Looking for a StorageArea that matches " + uriPath);
        for (StorageArea storageArea : StorageAreaManager.getInstance().getStorageAreas()) {
            if (!uriPath.startsWith(storageArea.getStfnRoot()) || matched != null && storageArea.getStfnRoot().length() <= matched.getStfnRoot().length()) continue;
            matched = storageArea;
        }
        if (matched == null) {
            log.debug("No match found");
        } else {
            log.debug("Matched StorageArea " + matched.toString());
        }
        return matched;
    }

    private StorageAreaManager(String stormBEHostname, int stormBEPort) throws Exception {
        this.beHostname = stormBEHostname;
        this.bePort = stormBEPort;
        this.storageAreas = this.retrieveStorageAreasFromStormBackend(stormBEHostname, stormBEPort);
        this.fsRootFromStfn = new HashMap();
        for (StorageArea sa : this.storageAreas) {
            this.fsRootFromStfn.put(sa.getStfnRoot(), sa.getFSRoot());
        }
        this.stfnRootFromFs = new HashMap();
        for (StorageArea sa : this.storageAreas) {
            this.stfnRootFromFs.put(sa.getFSRoot(), sa.getStfnRoot());
        }
    }

    private List<StorageArea> retrieveStorageAreasFromStormBackend(String beHostname, int bePort) throws Exception {
        log.info("Initializing StorageAreaManager from {'" + beHostname + "', " + bePort + "}");
        URI uri = this.buildConfigDiscoveryServiceUri(beHostname, bePort);
        HttpResponse httpResponse = this.callConfigDiscoveryService(uri);
        String output = this.getResponseBodyAsString(httpResponse.getEntity());
        ArrayList<StorageArea> storageAreaList = this.decodeStorageAreaList(output);
        return storageAreaList;
    }

    private String getResponseBodyAsString(HttpEntity entity) throws Exception {
        String output = "";
        if (entity != null) {
            InputStream responseIS;
            try {
                responseIS = entity.getContent();
            }
            catch (IllegalStateException e) {
                log.error("Unable to get the input content stream from server answer. IllegalStateException " + e.getLocalizedMessage());
                throw new Exception("Error comunicationg with the Configuration Discovery service.");
            }
            catch (IOException e) {
                log.error("Unable to get the input content stream from server answer. IOException " + e.getLocalizedMessage());
                throw new Exception("Error comunicationg with the Configuration Discovery service.");
            }
            byte[] tmp = new byte[1024];
            try {
                int l;
                while ((l = responseIS.read(tmp)) != -1) {
                    output = output + new String(tmp, 0, l);
                }
            }
            catch (IOException e) {
                log.error("Error reading from the connection error stream. IOException " + e.getMessage());
                throw new Exception("Error comunicationg with the authorization service.");
            }
        }
        log.error("No HttpEntity found in the response. Unable to determine the answer");
        throw new Exception("Unable to get a valid configuration discovery response from the server.");
        log.debug("Response is : '" + output + "'");
        return output;
    }

    private URI buildConfigDiscoveryServiceUri(String beHostname, int bePort) throws Exception {
        URI uri;
        log.debug("Building configurationd discovery rest service URI");
        String path = "/configuration/1.1/StorageAreaList";
        try {
            uri = new URI("http", null, beHostname, bePort, path, null, null);
        }
        catch (URISyntaxException e) {
            log.error("Unable to create Configuration Discovery URI. URISyntaxException " + e.getLocalizedMessage());
            throw new Exception("Unable to create Configuration Discovery URI");
        }
        log.debug("Built configuration discovery URI: " + uri);
        return uri;
    }

    private HttpResponse callConfigDiscoveryService(URI uri) throws Exception {
        log.info("Calling Configuration Discovery service at uri: " + uri);
        HttpGet httpget = new HttpGet(uri);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpResponse httpResponse = null;
        try {
            httpResponse = httpclient.execute((HttpUriRequest)httpget);
        }
        catch (ClientProtocolException e) {
            log.error("Error executing http call. ClientProtocolException " + e.getLocalizedMessage());
            throw new Exception("Error contacting Configuration Discovery service.");
        }
        catch (IOException e) {
            log.error("Error executing http call. IOException " + e.getLocalizedMessage());
            throw new Exception("Error contacting Configuration Discovery service.");
        }
        StatusLine status = httpResponse.getStatusLine();
        if (status == null) {
            log.error("Unexpected error! response.getStatusLine() returned null!");
            throw new Exception("Unexpected error! response.getStatusLine() returned null! Please contact storm support");
        }
        int httpCode = status.getStatusCode();
        String httpMessage = status.getReasonPhrase();
        log.debug("Http call return code is: " + httpCode);
        log.debug("Http call return reason phrase is: " + httpMessage);
        if (httpCode != 200) {
            log.warn("Unable to get a valid response from server. Received a non HTTP 200 response from the server : '" + httpCode + "' " + httpMessage);
            throw new Exception("Unable to get a valid response from server. " + httpMessage);
        }
        return httpResponse;
    }

    private ArrayList<StorageArea> decodeStorageAreaList(String storageAreaListString) {
        log.debug("Decoding the receive response");
        if (storageAreaListString == null) {
            log.error("Decoding failed, received a null storage area list string!");
            throw new IllegalArgumentException("Received a null storage area list string");
        }
        ArrayList<StorageArea> local = new ArrayList<StorageArea>();
        String[] SAEncodedArray = storageAreaListString.trim().split(":");
        log.info("Decoding " + SAEncodedArray.length + " storage areas");
        for (String SAEncoded : SAEncodedArray) {
            local.addAll(this.decodeStorageArea(SAEncoded));
        }
        return local;
    }

    private List<StorageArea> decodeStorageArea(String sAEncoded) {
        String[] SAFields;
        if (sAEncoded == null) {
            log.error("Decoding failed, received a null encoded storage area!");
            throw new IllegalArgumentException("Received a null encoded storage area");
        }
        log.debug("Decoding storage area string '" + sAEncoded + "'");
        ArrayList<StorageArea> producedList = new ArrayList<StorageArea>();
        String name = null;
        String root = null;
        ArrayList<String> stfnRootList = new ArrayList<String>();
        ArrayList<String> protocolList = new ArrayList<String>();
        for (String SAField : SAFields = sAEncoded.trim().split("&")) {
            String[] protocolsArray;
            String[] keyValue = SAField.trim().split("=");
            if ("name".equals(keyValue[0])) {
                name = keyValue[1];
                log.debug("Found name: " + name);
                continue;
            }
            if ("root".equals(keyValue[0])) {
                root = keyValue[1];
                log.debug("Found File System Root: " + root);
                continue;
            }
            if ("stfnRoot".equals(keyValue[0])) {
                String[] stfnRootArray;
                for (String stfnRoot : stfnRootArray = keyValue[1].trim().split(";")) {
                    stfnRootList.add(stfnRoot);
                    log.debug("Found Storage File Name Root: " + stfnRoot);
                }
                continue;
            }
            if (!"protocols".equals(keyValue[0])) continue;
            for (String protocol : protocolsArray = keyValue[1].trim().split(";")) {
                protocolList.add(protocol);
                log.debug("Found Storage WebDAV protocol: " + protocol);
            }
        }
        if (name == null || root == null || stfnRootList.size() == 0) {
            log.warn("Unable to decode the storage area. Some fileds are missin: name=" + name + " FSRoot=" + root + " stfnRootList=" + stfnRootList + " protocolList=" + protocolList);
            throw new IllegalArgumentException("");
        }
        for (String stfnRoot : stfnRootList) {
            StorageArea storageArea = new StorageArea(name, root, stfnRoot, protocolList);
            log.info("Decoded storage area: [" + storageArea.toString() + "]");
            producedList.add(storageArea);
        }
        log.debug("Decoded " + producedList.size() + " storage areas");
        return producedList;
    }
}

