/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.utils.https.impl.canl;

import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import javax.net.ssl.SSLContext;
import org.eclipse.jetty.server.Connector;
import org.italiangrid.utils.https.JettySSLConnectorConfigurator;
import org.italiangrid.utils.https.SSLOptions;
import org.italiangrid.utils.https.impl.SSLContextConnectorConfigurator;
import org.italiangrid.utils.https.impl.canl.CANLListener;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CANLSSLConnectorConfigurator
implements JettySSLConnectorConfigurator {
    public static final Logger log = LoggerFactory.getLogger(CANLSSLConnectorConfigurator.class);
    public static final NamespaceCheckingMode DEFAULT_NAMESPACE_CHECKING_MODE = NamespaceCheckingMode.EUGRIDPMA_AND_GLOBUS;
    SSLContextConnectorConfigurator configurator;
    X509CertChainValidatorExt certChainValidator;

    public CANLSSLConnectorConfigurator() {
    }

    public CANLSSLConnectorConfigurator(X509CertChainValidatorExt validator) {
        this.certChainValidator = validator;
    }

    @Override
    public Connector configureConnector(String host, int port, SSLOptions options) {
        try {
            PEMCredential serviceCredentials = new PEMCredential(options.getKeyFile(), options.getCertificateFile(), options.getKeyPassword());
            if (this.certChainValidator == null) {
                CANLListener l = new CANLListener();
                this.certChainValidator = CertificateValidatorBuilder.buildCertificateValidator(options.getTrustStoreDirectory(), l, l, options.getTrustStoreRefreshIntervalInMsec());
            }
            SSLContext sslContext = SocketFactoryCreator.getSSLContext(serviceCredentials, this.certChainValidator, null);
            this.configurator = new SSLContextConnectorConfigurator(sslContext);
            return this.configurator.configureConnector(host, port, options);
        }
        catch (Throwable t) {
            log.error("SSL initialization error!", t);
            return null;
        }
    }
}

