/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.gridhttps.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import it.grid.storm.gridhttps.server.StormGridhttpsServer;
import it.grid.storm.gridhttps.server.data.StormBackend;
import it.grid.storm.gridhttps.server.data.StormFrontend;
import it.grid.storm.gridhttps.server.data.StormGridhttps;
import it.grid.storm.gridhttps.server.exceptions.InitException;
import it.grid.storm.gridhttps.server.exceptions.ServerException;
import it.grid.storm.gridhttps.server.utils.FileUtils;
import it.grid.storm.gridhttps.server.utils.MyCommandLineParser;
import it.grid.storm.storagearea.StorageAreaManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.ini4j.Wini;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static Logger log;
    public static String webappFileName;
    public static String configurationFileName;
    private static StormBackend stormBackend;
    private static StormFrontend stormFrontend;
    private static StormGridhttps stormGridhttps;
    private static StormGridhttpsServer server;

    public static void main(String[] args) {
        System.out.println("StoRM Gridhttps-server");
        System.out.println("bootstrapping...");
        try {
            Main.parseCommandLine(args);
            Main.loadDefaultConfiguration();
            Main.loadConfiguration();
            Main.checkConfiguration();
            Main.initLogging(stormGridhttps.getLogFile());
            Main.initStorageAreas(stormBackend.getHostname(), stormBackend.getServicePort());
            Main.printConfiguration();
            Main.deleteWebappDirectory();
            server = new StormGridhttpsServer(stormGridhttps, stormBackend, stormFrontend);
            server.start();
            server.status();
        }
        catch (InitException e) {
            System.err.println(e.getMessage());
            System.exit(0);
        }
        catch (ServerException e) {
            log.error(e.getMessage());
            System.exit(0);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.debug("Exiting gridhttps-server...");
                if (server != null && server.isRunning()) {
                    log.info("Shutting down server...");
                    try {
                        server.stop();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
                log.debug("Deleting webapp temporary directory...");
                Main.deleteWebappDirectory();
                log.info("Bye");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitfor(int waitfor) {
        if (waitfor == 0) {
            return;
        }
        Object lock = new Object();
        System.out.println("Waiting for " + waitfor + " ms");
        Object object = lock;
        synchronized (object) {
            try {
                lock.wait(waitfor);
                System.out.println("It's time to boot!");
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private static void deleteWebappDirectory() {
        File toDelete = new File(stormGridhttps.getWebappsDirectory(), "gridhttps-server/webapp");
        if (toDelete.exists()) {
            try {
                FileUtils.deleteDirectory(toDelete);
            }
            catch (IOException e) {
                log.error(e.getMessage());
            }
        }
    }

    private static void initStorageAreas(String hostname, int port) throws InitException {
        try {
            StorageAreaManager.init(hostname, port);
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    private static void checkConfiguration() throws InitException {
        System.out.println("checking backend configuration...");
        stormBackend.checkConfiguration();
        System.out.println("checking frontend configuration...");
        stormFrontend.checkConfiguration();
        System.out.println("checking gridhttps configuration...");
        stormGridhttps.checkConfiguration();
    }

    private static void initLogging(String logFilePath) throws InitException {
        System.out.println("init logging...");
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        loggerContext.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(loggerContext);
        try {
            FileInputStream fin = new FileInputStream(logFilePath);
            configurator.doConfigure(fin);
            fin.close();
        }
        catch (FileNotFoundException e) {
            throw new InitException(e);
        }
        catch (JoranException e) {
            throw new InitException(e);
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        loggerContext.start();
        log = LoggerFactory.getLogger(Main.class);
        System.out.println("log successfully initialized");
    }

    private static void parseCommandLine(String[] args) throws InitException {
        System.out.println("received as command line arguments: ");
        MyCommandLineParser cli = new MyCommandLineParser(args);
        cli.addOption("w", "the absolute file path of the WebDAV webapp template [mandatory]", true, true);
        cli.addOption("conf", "the absolute file path of the server configuration file [mandatory]", true, true);
        try {
            webappFileName = cli.getString("w");
            System.out.println("webapp-file: " + webappFileName);
            configurationFileName = cli.getString("conf");
            System.out.println("configuration-file: " + configurationFileName);
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    private static void loadDefaultConfiguration() throws InitException {
        InetAddress localMachine;
        stormGridhttps = new StormGridhttps();
        try {
            localMachine = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new InitException(e);
        }
        stormGridhttps.setHostname(localMachine.getHostName());
        stormGridhttps.setWarFile(new File(webappFileName));
        stormBackend = new StormBackend();
        stormBackend.setHostname(localMachine.getHostName());
        stormFrontend = new StormFrontend();
        stormFrontend.setHostname(localMachine.getHostName());
    }

    private static void loadConfiguration() throws InitException {
        Wini configuration;
        System.out.println("loading configuration from file...");
        try {
            configuration = new Wini(new File(configurationFileName));
        }
        catch (InvalidFileFormatException e) {
            throw new InitException(e);
        }
        catch (IOException e) {
            throw new InitException(e);
        }
        if (!configuration.keySet().contains("service")) {
            throw new InitException("Configuration file 'service' section missed!");
        }
        if (((Profile.Section)configuration.get("service")).containsKey("log.configuration-file")) {
            stormGridhttps.setLogFile(configuration.get((Object)"service", "log.configuration-file"));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("webapp-directory")) {
            stormGridhttps.setWebappsDirectory(configuration.get((Object)"service", "webapp-directory"));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("webdav.context-path")) {
            stormGridhttps.setWebdavContextPath(configuration.get((Object)"service", "webdav.context-path"));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("filetransfer.context-path")) {
            stormGridhttps.setFiletransferContextPath(configuration.get((Object)"service", "filetransfer.context-path"));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("mapping.max.active.threads")) {
            stormGridhttps.setMapActiveThreadsMax(configuration.get("service", "mapping.max.active.threads", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("mapping.max.queued.threads")) {
            stormGridhttps.setMapQueuedThreadsMax(configuration.get("service", "mapping.max.queued.threads", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("webdav.max.active.threads")) {
            stormGridhttps.setDavActiveThreadsMax(configuration.get("service", "webdav.max.active.threads", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("service")).containsKey("webdav.max.queued.threads")) {
            stormGridhttps.setDavQueuedThreadsMax(configuration.get("service", "webdav.max.queued.threads", Integer.TYPE));
        }
        if (!configuration.keySet().contains("connectors")) {
            throw new InitException("Configuration file 'connectors' section missed!");
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("http.enabled")) {
            stormGridhttps.setEnabledHttp(configuration.get("connectors", "http.enabled", Boolean.TYPE));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("http.port")) {
            stormGridhttps.setHttpPort(configuration.get("connectors", "http.port", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("https.port")) {
            stormGridhttps.setHttpsPort(configuration.get("connectors", "https.port", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("mapper.servlet.port")) {
            stormGridhttps.getMapperServlet().setPort(configuration.get("connectors", "mapper.servlet.port", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("x509.host-certificate")) {
            stormGridhttps.getSsloptions().setCertificateFile(configuration.get((Object)"connectors", "x509.host-certificate"));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("x509.host-key")) {
            stormGridhttps.getSsloptions().setKeyFile(configuration.get((Object)"connectors", "x509.host-key"));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("x509.truststore.directory")) {
            stormGridhttps.getSsloptions().setTrustStoreDirectory(configuration.get((Object)"connectors", "x509.truststore.directory"));
        }
        if (((Profile.Section)configuration.get("connectors")).containsKey("x509.truststore.refresh-interval")) {
            stormGridhttps.getSsloptions().setTrustStoreRefreshIntervalInMsec(configuration.get("connectors", "x509.truststore.refresh-interval", Long.TYPE));
        }
        if (!configuration.keySet().contains("backend")) {
            throw new InitException("Configuration file 'backend' section missed!");
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("backend.hostname")) {
            stormBackend.setHostname(configuration.get((Object)"backend", "backend.hostname"));
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("backend.authorization-service.port")) {
            stormBackend.setServicePort(configuration.get("backend", "backend.authorization-service.port", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("backend.srm-service.port")) {
            stormBackend.setPort(configuration.get("backend", "backend.srm-service.port", Integer.TYPE));
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("srm.endpoint")) {
            stormFrontend.setHostname(configuration.get((Object)"backend", "srm.endpoint").split(":")[0]);
            stormFrontend.setPort(Integer.valueOf(configuration.get((Object)"backend", "srm.endpoint").split(":")[1]));
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("root-directory")) {
            stormGridhttps.setRootDirectory(new File(configuration.get((Object)"backend", "root-directory")));
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("compute-checksum")) {
            stormGridhttps.setComputeChecksum(configuration.get("backend", "compute-checksum", Boolean.TYPE));
        }
        if (((Profile.Section)configuration.get("backend")).containsKey("checksum-type")) {
            if (!configuration.get((Object)"backend", "checksum-type").toLowerCase().equals("adler32".toLowerCase())) {
                log.warn("Invalid checksum type: " + configuration.get((Object)"backend", "checksum-type"));
            } else {
                stormGridhttps.setChecksumType(configuration.get((Object)"backend", "checksum-type"));
            }
        }
        System.out.println("configuration successfully loaded");
    }

    private static void printConfiguration() {
        log.debug("storm backend = " + stormBackend);
        log.debug("storm frontend = " + stormFrontend);
        log.debug("storm gridhttps = " + stormGridhttps);
    }
}

