/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.pkipath;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.crl.PlainCRLStoreSpi;
import eu.emi.security.authn.x509.helpers.pkipath.AbstractValidator;
import eu.emi.security.authn.x509.impl.CRLParameters;
import eu.emi.security.authn.x509.impl.RevocationParametersExt;
import java.security.InvalidAlgorithmParameterException;
import java.util.Collection;
import java.util.List;
import java.util.Timer;

public abstract class PlainCRLValidator
extends AbstractValidator {
    protected PlainCRLStoreSpi crlStoreImpl;
    protected RevocationParametersExt revocationParameters;
    protected static final Timer timer = new Timer("caNl validator (PlainCRL) timer", true);

    public PlainCRLValidator(RevocationParametersExt revocationParams, Collection<? extends StoreUpdateListener> listeners) {
        super(listeners);
        if (revocationParams == null) {
            throw new IllegalArgumentException("CRLParameters argument can not be null");
        }
        this.revocationParameters = revocationParams.clone();
        this.crlStoreImpl = this.createCRLStore(revocationParams.getCrlParameters(), timer);
    }

    protected PlainCRLStoreSpi createCRLStore(CRLParameters crlParams, Timer t) {
        try {
            return new PlainCRLStoreSpi(crlParams, t, this.observers);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException("BUG: PlainCRLStoreSpi can not be initialized with CRLParameters", e);
        }
    }

    public RevocationParametersExt getRevocationParameters() {
        return this.revocationParameters.clone();
    }

    public long getCRLUpdateInterval() {
        return this.crlStoreImpl.getUpdateInterval();
    }

    public void setCRLUpdateInterval(long updateInterval) {
        this.revocationParameters.getCrlParameters().setCrlUpdateInterval(updateInterval);
        this.crlStoreImpl.setUpdateInterval(updateInterval);
    }

    public List<String> getCrls() {
        return this.crlStoreImpl.getLocations();
    }

    public synchronized void setCrls(List<String> crls) {
        this.crlStoreImpl.dispose();
        this.revocationParameters.getCrlParameters().setCrls(crls);
        this.crlStoreImpl = this.createCRLStore(this.revocationParameters.getCrlParameters(), timer);
        this.init(null, this.crlStoreImpl, this.getProxySupport(), this.getRevocationCheckingMode());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.crlStoreImpl.dispose();
    }
}

