import os
import exceptions
import logging

from storm.monitoring.sensor.api import units
from storm.monitoring.sensor.api import measure

class VMstatError(exceptions.Exception):
    pass

class VMStat(object):
    """Checks memory of a given system"""
         
    def __init__(self):
        self.logger = logging.getLogger("storm_sensor.cpu_check")
        self.logger.info("creating an instance of VMStat")

        if os.name == "posix":
            cs,us,sy,id,wa,st,unit = self.linux_cpu()
            self.cs = measure.Measure(cs, unit, 'cpu nice')
            self.us = measure.Measure(us, unit, 'cpu user')
            self.sy = measure.Measure(sy, unit, 'cpu system')
            self.id = measure.Measure(id, unit, 'cpu idle')
            self.wa = measure.Measure(wa, unit, 'cpu wait')
            self.st = measure.Measure(st, unit, 'cpu steal')
        else:   
            raise VMStatError('I only work with Linux :P')
         
    def linux_cpu(self):
        """Returns the CPU of a linux system"""
        self.logger.info("getting linux cpu information")
        cs,us,sy,id,wa,st = os.popen("vmstat").readlines()[2].split()[11:17]
        return int(cs), int(us), int(sy),int(id),int(wa),int(st), units.Units().percentage

    def get_cs(self):
        """Returns cs: The number of context switches per second"""
        self.logger.info("getting cs information")
        return self.cs

    def get_us(self):
        """Returns us: Time spent running non-kernel code"""
        self.logger.info("getting user time information")
        return self.us

    def get_sy(self):
        """Returns sy: Time spent running kernel code"""
        self.logger.info("getting system time information")
        return self.sy

    def get_id(self):
        """Returns id: Time spent idle"""
        self.logger.info("getting idle time information")
        return self.id

    def get_wa(self):
        """Returns wa: Time spent waiting for IO"""
        self.logger.info("getting wait time information")
        return self.wa

    def get_st(self):
        self.logger.info("getting status information")
        return self.st

     
