import logging

from storm.monitoring.sensor.api import services
from storm.monitoring.sensor.api import metrics

moduel_logger = logging.getLogger("storm_sensor.usage")

def usage_version(opt=True):
    if not opt:
        print """- version is not followed by any value"""
    else:
        print """                   [-V|--version] """
    
def usage_verbose(opt=True):
    if not opt:
        print """- verbose is not followed by any value"""
    else:
        print """                   [-v|--verbose] """

def usage_metric(opt=True):
    if not opt:
        print """- metric is followed by one of the following values"""
        tmp = metrics.Metrics().get_string_metrics()
        for val in tmp.keys():
             print """  %s """ % tmp[val]  
    else:
        print """                   <-m|--metric> """

def usage_conf(opt=True):
    if not opt:
        print """- conf is followed by an INI file of the form"""
        print """  [storm_nodes]"""
        print """  frontend=false"""
        print """  backend=false"""
        print """  gridftp=false"""
        print """  gridhttps=false"""
        print """  The options represent the StoRM nodes the default"""
        print """  of which is false."""
    else:
        print """                   <-c|--conf>"""

def get_usage():
    module_logger.info("getting usage")
    
    print 'Usage: storm-sensor [-h|--help] '
    usage_version()
    #usage_verbose()
    usage_metric()
    usage_conf()

    usage_version(opt=False)
    #usage_verbose(opt=False)
    usage_metric(opt=False)
    usage_conf(opt=False)
