import os
import logging
import logging.handlers

class CompressedRotatingFileHandler(logging.handlers.RotatingFileHandler):
    """ A class extending RotatingFileHandler to compress files. """

    def doRollover(self):
        """ Do a rollover and compress the files. """
        self.stream.close()
        if self.backupCount > 0:
            for i in range(self.backupCount - 1, 0, -1):
                sfn = "%s.%d.gz" % (self.baseFilename, i)
                dfn = "%s.%d.gz" % (self.baseFilename, i + 1)
                if os.path.exists(sfn):
                    if os.path.exists(dfn):
                        os.remove(dfn)
                    os.rename(sfn, dfn)
            dfn = self.baseFilename + ".1.gz"
            if os.path.exists(dfn):
                os.remove(dfn)
            # gzip here
            f_in = open(self.baseFilename, "r")
            f_out = gzip.open(dfn, "w")
            f_out.writelines(f_in)
            f_out.close()
            f_in.close()
            os.remove(self.baseFilename)
        self.mode = "w"
        self.stream = open(self.baseFilename, "w")
