import exceptions

class ServicesError(exceptions.Exception):
    pass

class Services:

    frontend=0
    backend=1
    gridftp=2
    gridhttps=3

    def __init__(self):
        self.services_types = [Services.frontend,
            Services.backend,
            Services.gridftp,
            Services.gridhttps]

        self.string_services = {
            Services.frontend: 'FRONTEND',
            Services.backend: 'BACKEND',
            Services.gridftp: 'GRIDFTP',
            Services.gridhttps: 'GRIDHTTPS'
            }

        self.log_files_for_services = {
            Services.frontend: '/var/log/storm/storm-frontend-server.log',
            Services.backend: ['/var/log/storm/storm-backend.log','/var/log/storm/storm-backend.stdout', '/var/log/storm/storm-backend.stderr','/var/log/storm/heartbeat.log','/var/log/storm/lcmaps.log'],
            Services.gridftp: ['/var/log/storm/storm-globus-gridftp.log', '/var/log/storm/storm-gridftp-session.log'],
            Services.gridhttps: ['/var/log/storm/storm-gridhttps-server.log']
            }

        self.service_names_for_services = {
            Services.frontend: 'storm-frontend-server',
            Services.backend: 'storm-backend-server',
            Services.gridftp: 'storm-globus-gridftp',
            Services.gridhttps: 'storm-gridhttps-server'
            }

    def is_service(self, value):
        if value in self.services_types:
            return True
        return False

    def get_services(self):
        #services = []
        #for x in self.services_types:
        #    services.extend(x)
        return self.services_types

    def get_string_services(self):
        return self.string_services

    def get_string_service(self, service_type):
        if self.is_service(service_type):
            return self.string_services[service_type]
        else:
            msg = 'The specified service %s is wrong' % str(service_type)
            raise ServicesError(msg)

    def get_log_files_for_service_type(self, service_type):
        if self.is_service(service_type):
            return self.log_files_for_services[service_type]
        else:
            msg = 'The specified service %s is wrong' % str(service_type)
            raise ServicesError(msg)

    def get_service_names_for_service_type(self, service_type):
        if self.is_service(service_type):
            return self.service_names_for_services[service_type]
        else:
            msg = 'The specified service %s is wrong' % str(service_type)
            raise ServicesError(msg)
