import exceptions

class MetricsError(exceptions.Exception):
    pass

class Metrics(object):

    cpu=0
    mem=1
    file_descriptor=2
    log_size=3
    mysql_load=4
    proc_mem=5

    def __init__(self):
        self.metrics_types = {
            'host':[Metrics.cpu,
                Metrics.mem],
            'service':[Metrics.log_size,
                Metrics.proc_mem,
                Metrics.file_descriptor],
            'service_dependant':[Metrics.mysql_load]
            }

        self.string_metrics = {
            Metrics.cpu: 'cpu',
            Metrics.mem: 'mem',
            Metrics.log_size: 'log_size',
            Metrics.proc_mem: 'proc_mem',
            Metrics.file_descriptor: 'file_descriptor',
            Metrics.mysql_load: 'mysql_load'
            }

    def is_host_metric(self, metric_type):
        if metric_type in self.metrics_types['host']:
            return True
        return False

    def is_service_metric(self, metric_type):
        if metric_type in self.metrics_types['service']:
            return True
        return False

    def is_service_dependant_metric(self, metric_type):
        if metric_type in self.metrics_types['service_dependant']:
            return True
        return False

    def get_metrics(self):
        metrics = []
        for x in self.metrics_types.values():
            metrics.extend(x)
        return metrics

    def get_string_metrics(self):
        return self.string_metrics

    def get_string_metric(self, metric_type):
        if self.is_host_metric(metric_type):
            return self.string_metrics[metric_type]
        elif self.is_service_metric(metric_type):
            return self.string_metrics[metric_type]
        elif self.is_service_dependant_metric(metric_type):
            return self.string_metrics[metric_type]
        else:
            msg = 'The specified metric %s is wrong' % str(metric_type)
            raise MetricsError(msg)
