from storm.monitoring.sensor.api import units

class Measure(object):

    def __init__(self, value, unit_type, description = ''):
        self.value = value
        if unit_type not in units.Units().get_units():
            msg = 'The specified unit type %s is not supported' % str(unit_type)
            raise units.UnitsError(msg)
        self.unit = unit_type
        self.description = description 
    
    def get_value(self):
        """Return measure value"""
        return self.value

    def get_unit(self):
        """Return measure information"""
        return self.unit

    def get_description(self):
        """Return measure information"""
        return self.description
