#ifndef SEMSGPROTODEFS_HH
#define SEMSGPROTODEFS_HH
/* SEMsgProtoDefs
 * Protocol definitions
 * Here we define all the constants that are used as protocol elements
 *  at the application level
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 */


//-----------------------------------------
// Current version of the protocol (this one)
#define PROTO_MAJOR         1
#define PROTO_MINOR         0
#define PROTO_PATCH         0




//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
// Tags for the header
//

// Proto version
#define PROTO_MAJOR_NAME    "Proto_Major"
#define PROTO_MINOR_NAME    "Proto_Minor"
#define PROTO_PATCH_NAME    "Proto_Patch"


// Tag for the command name
#define PROTO_CMD_NAME      "Command"

// Tag for the signature and the sender's public cert
#define PROTO_SIGNATURE     "Signature"
#define PROTO_SENDERDN      "SenderDN"
#define PROTO_X509CERT      "Cert"

// Tag for the DN that shall perform the operation (generally the DN that triggered
// the sending of a notification)
#define PROTO_AUTHDN        "AuthDN"

// ---------- Tags that qualify the command
#define PROTO_CMD_CHMOD            "Chmod"
#define PROTO_CMD_CHOWN            "Chown"
#define PROTO_CMD_FILEAVAILABLE    "FileAvailable"
#define PROTO_CMD_FILEDELETED      "FileDeleted"
#define PROTO_CMD_FILENOTAVAILABLE "FileNotAvailable"
#define PROTO_CMD_ADDREPLICA       "AddReplica"
#define PROTO_CMD_SETACL           "SetACL"

// Tag for the count of independent file entries in the message (bulk usage)
// If this tag is absent then the count is assumed as 1 and the items have no
// concatenated number
// If NENTRIES appears in the message, then the receivers should expect to
// find in the message ALL the items for that kind of message numbered from
// 1 to NENTRIES, inclusive
#define PROTO_NENTRIES       "NEntries"

//----------------------------------------------------------------------------------
//----------------------------------------------------------------------------------
// Tags for the body
//
// These tags may be concatenated with a  number that identifies the entry
// in a bulk message. E.g. Filename0001
//
// The suffix chosen for the constants tell us, just for convenience, the type of the value.
// Here's the suffix table with the correspondence:
//     
//   Sfx   C type            AMQ type 
//   --------------------------------
//    S    String            String
//    L    long              Int
//    LL   long long         Long


// ----------------
// Addreplica 
#define PROTO_ADDREPLICA_LFN_S            "Lfn"
#define PROTO_ADDREPLICA_GUID_S           "Guid"
#define PROTO_ADDREPLICA_MODE_L           "Mode"
#define PROTO_ADDREPLICA_SIZE_LL          "Size"
#define PROTO_ADDREPLICA_CSUMTYPE_S       "Csumtype"
#define PROTO_ADDREPLICA_CSUMVALUE_S      "Csumvalue"
#define PROTO_ADDREPLICA_SERVER_S         "Server"
#define PROTO_ADDREPLICA_SFN_S            "Sfn"
#define PROTO_ADDREPLICA_STATUS_S         "Status"
#define PROTO_ADDREPLICA_F_TYPE_S         "F_type"
#define PROTO_ADDREPLICA_POOLNAME_S       "Poolname"
#define PROTO_ADDREPLICA_FS_S             "Fs"


// ----------------
// Chmod
#define PROTO_CHMOD_FILENAME_S            "Filename"
#define PROTO_CHMOD_UNIXPERM_L            "UnixPerm"

// ----------------
// Chown
#define PROTO_CHOWN_FILENAME_S            "Filename"
#define PROTO_CHOWN_USERNAME_S            "Username"
#define PROTO_CHOWN_GROUPNAME_S           "Groupname"

// ----------------
// SetACL
#define PROTO_SETACL_FILENAME_S           "Filename"
#define PROTO_SETACL_ACLENTRIES_S         "ACLEntries"

// ----------------
// FileDeleted
#define PROTO_FILEDELETED_FILENAME_S      "Filename"

// ----------------
// FileNotAvailable
#define PROTO_FILENOTAVAILABLE_FILENAME_S "Filename"

// ----------------
// FileAvailable
#define PROTO_FILEAVAILABLE_FILENAME_S    "Filename"

#endif
