#ifndef RUNNABLE_PRODUCER_HH
#define RUNNABLE_PRODUCER_HH

/* RunnableProducer
 * A simple runnable that produces messages and implements
 * async connection capabilities
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 */

#include "SimpleProducer.hh"
#include "SEMsgProtoDefs.hh"
#include <decaf/lang/Runnable.h>
#include <decaf/lang/Thread.h>
#include <decaf/util/concurrent/Mutex.h>
#include <decaf/util/concurrent/Lock.h>
#include <decaf/util/concurrent/locks/ReentrantLock.h>
#include <cms/ExceptionListener.h>
#include <cms/MapMessage.h>

#include <map>
#include <string>

class RunnableProducer : public decaf::lang::Runnable, public SimpleProducer, public cms::ExceptionListener {
private:
   bool isConnected, isTerminated;
   decaf::lang::Thread *thr;
public:


   RunnableProducer( const std::string& brokerURI,
                        const std::string& destname,
                        bool useTopic = false,
                        bool sessionTransacted = false ):
      decaf::lang::Runnable(), SimpleProducer(brokerURI, destname, useTopic, sessionTransacted),
      isConnected(false), isTerminated(false), thr(NULL), testSendMsgs(0) { 

     queueFullCond = queueLock.newCondition();
     queueEmptyCond = queueLock.newCondition();
   };

   virtual ~RunnableProducer() {
     delete queueFullCond;
     delete queueEmptyCond;
   };

   int testSendMsgs;

   virtual int Start();
   virtual int Join();

   // Wait at max millisec for the send queue to be empty
   // 0 means wait forever for it to be empty
   // Return true if lock acquired
   virtual bool WaitQueueEmpty(int maxmillis);

   virtual void Term();

   virtual void onException (const cms::CMSException &ex);

   virtual void run();

   // ---------------------------------------------------
   // Intf and implementation of the full async sending
   typedef std::map<std::string, std::string> TStrStrMap;
   typedef std::pair<std::string, std::string> TStrStrPair;

   typedef std::map<std::string, long> TStrLongMap;
   typedef std::pair<std::string, long> TStrLongPair;

   typedef std::map<std::string, long long> TStrLonglongMap;
   typedef std::pair<std::string, long long> TStrLonglongPair;

   // Our message class, to be enqueued to support async operation
   class localMsg {
     public:
      TStrStrMap hdrstr;
      TStrLongMap hdrlong;
      TStrLonglongMap hdrlonglong;

      TStrStrMap bodystr;
      TStrLongMap bodylong;
      TStrLonglongMap bodylonglong;

      bool beingSent;
      time_t insTime;

      localMsg(char *cmdname): beingSent(false) {
	hdrlong.insert(TStrLongPair(PROTO_MAJOR_NAME, PROTO_MAJOR));
	hdrlong.insert(TStrLongPair(PROTO_MINOR_NAME, PROTO_MINOR));
	hdrlong.insert(TStrLongPair(PROTO_PATCH_NAME, PROTO_PATCH));
	hdrstr.insert(TStrStrPair(PROTO_CMD_NAME, cmdname));
	insTime = time(0);
      }

   };

   // From an instance of myMsg, create a message to be sent to the broker
   cms::Message *GetMapMessage(localMsg *msg);

  // Sign the message
  virtual int SignMessage( cms::MapMessage* m ) {
    return 0;
  };

  // Check the signature of the message
  virtual int CheckMessage( const cms::MapMessage* m ) {
    return 0;
  };

protected:
  typedef std::vector<localMsg *> TsendQ;
  TsendQ sendQ;
  decaf::util::concurrent::locks::ReentrantLock queueLock;
  decaf::util::concurrent::locks::Condition *queueEmptyCond, *queueFullCond;

};




#endif
