#ifndef MSGPRODUCERCAPI_H
#define MSGPRODUCERCAPI_H

/* MsgProducerAPI
 * My simple application-level API for storage-related C clients
 *
 *
 * by Fabrizio Furano, CERN, Oct 2010
 *
 */


/*  ------------------------------------
 *  Initialization and finalization
 * ------------------------------------ */
int MsgProd_Init(char *brokerURI, char *topicorqueue, int istopicorqueue, char *pluginname, int debuglevel);

void MsgProd_Terminate();





// ------------------------------------
// Utility function, to pack the voms auth stuff into a string buffer
// ------------------------------------
void MsgProd_PackAuthstuff(char *destbuf, char *DN, char *voname, char **fqans, int nfqans);








/*  ------------------------------------
 *  Pre-cooked primitives to send specific things
 *  ------------------------------------ */

/* Send a notification containing a silly statement. */
/* Please make sure that it's silly enough. */
int MsgProd_Notifysillymessage(char *sillymessage);


int MsgProd_NotifyNotAvailable(char *authDN, char *filename);
int MsgProd_NotifyAvailable(char *authDN, char *filename);
int MsgProd_NotifyChmod(char *authDN, char *filename, int perm);
int MsgProd_NotifyChown(char *authDN, char *filename, char *username, char *groupname);
int MsgProd_NotifyDeleted(char *authDN, char *filename);
int MsgProd_NotifySetACL(char *authDN, char *filename, char *acl);
int MsgProd_NotifyAddReplica(char *authDN,
			     char      *lfn,
                             char      *guid,
                             int        mode,
                             long long  size,
                             char      *csumtype,
                             char      *csumvalue,
                             char      *server,
                             char      *sfn,
                             char      *status,
                             char      *f_type,
                             char      *poolname,
                             char      *fs);

int MsgProd_CanNotifyNotAvailable();
int MsgProd_CanNotifyAvailable();
int MsgProd_CanNotifyChmod();
int MsgProd_CanNotifyChown();
int MsgProd_CanNotifyDeleted();
int MsgProd_CanNotifySetACL();
int MsgProd_CanNotifyAddReplica();

#endif
