/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.ui.client;

import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicNameValuePair;
import org.glite.pseudo.common.http.HttpClientBuilder;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.ui.client.PseudoServiceClientException;
import org.glite.pseudo.ui.client.message.CertInfoResponse;
import org.glite.pseudo.ui.client.message.CertResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoServiceClient {
    private static final Logger log = LoggerFactory.getLogger(PseudoServiceClient.class);
    protected String gridProxyFile;
    protected String caDirectory;
    protected String truststore;
    protected String truststorePwd;
    protected boolean crlRequired;

    public PseudoServiceClient(String gridProxyFile, String caDirectory, boolean crlRequired) {
        this.gridProxyFile = gridProxyFile;
        this.caDirectory = caDirectory;
        this.crlRequired = crlRequired;
    }

    public PseudoServiceClient(String gridProxyFile, String truststore, String truststorePwd, boolean crlRequired) {
        this.gridProxyFile = gridProxyFile;
        this.truststore = truststore;
        this.truststorePwd = truststorePwd;
        this.crlRequired = crlRequired;
    }

    public CertInfoResponse login(URL serviceUrl) throws PseudoServiceClientException {
        HttpClient httpClient;
        HttpClientBuilder httpBuilder = new HttpClientBuilder(serviceUrl, this.gridProxyFile);
        try {
            httpClient = httpBuilder.buildClient();
        }
        catch (IOException e) {
            throw new PseudoServiceClientException("Could not read the required files for initializing the Http client!", e);
        }
        catch (GeneralSecurityException e) {
            throw new PseudoServiceClientException("Security-error while initializing the Http client!", e);
        }
        HttpGet httpRequest = new HttpGet(serviceUrl.toString());
        HttpResponse httpResponse = null;
        CertInfoResponse result = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            result = new CertInfoResponse(httpResponse);
        }
        catch (ClientProtocolException e) {
            log.error("Could not login to the Pseudonymity Service", (Throwable)e);
            throw new PseudoServiceClientException("Protocol error while contacting the service!", (Exception)((Object)e));
        }
        catch (IOException e) {
            log.error("Could not login to the Pseudonymity Service", (Throwable)e);
            throw new PseudoServiceClientException("IO error while contacting the service!", e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return result;
    }

    public CertResponse sendCertRequest(CertificateRequest csr, URL serviceUrl, String authorizationToken) throws PseudoServiceClientException {
        HttpClientBuilder httpBuilder = new HttpClientBuilder(serviceUrl, this.gridProxyFile);
        HttpClient httpClient = null;
        try {
            httpClient = httpBuilder.buildClient();
        }
        catch (IOException e) {
            throw new PseudoServiceClientException("Could not read the required files for initializing the Http client!", e);
        }
        catch (GeneralSecurityException e) {
            throw new PseudoServiceClientException("Security-error while initializing the Http client!", e);
        }
        HttpPost httpRequest = new HttpPost(serviceUrl.toString());
        ArrayList<BasicNameValuePair> httpRequestParams = new ArrayList<BasicNameValuePair>();
        httpRequestParams.add(new BasicNameValuePair("AuthorizationToken", authorizationToken));
        httpRequestParams.add(new BasicNameValuePair("CertificateSigningRequest", csr.getPEMEncoded()));
        HttpResponse httpResponse = null;
        CertResponse result = null;
        try {
            httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(httpRequestParams, "UTF-8"));
            httpResponse = httpClient.execute((HttpUriRequest)httpRequest);
            result = new CertResponse(httpResponse);
        }
        catch (ClientProtocolException e) {
            log.error("Could not obtain the certificate from the Pseudonymity Service", (Throwable)e);
            throw new PseudoServiceClientException("Protocol error while contacting the service!", (Exception)((Object)e));
        }
        catch (IOException e) {
            log.error("Could not obtain the certificate from the Pseudonymity Service", (Throwable)e);
            throw new PseudoServiceClientException("IO error while contacting the service!", e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
        return result;
    }
}

