/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.util;

import javax.security.auth.x500.X500Principal;

public class EventUtil {
    public static String getEventTypeString(int eventType) {
        String result = eventType + ": ";
        switch (eventType) {
            case 201: {
                result = result + "Issued DN";
                break;
            }
            case 301: {
                result = result + "Requested certificate";
                break;
            }
            case 302: {
                result = result + "Issued certificate";
                break;
            }
            case 303: {
                result = result + "Registered certificate";
                break;
            }
            case 100: {
                result = result + "Admin login";
                break;
            }
            case 101: {
                result = result + "Admin list events";
                break;
            }
            case 102: {
                result = result + "Admin event details";
                break;
            }
            default: {
                result = result + "Unknown type";
            }
        }
        return result;
    }

    public static String getEventLevelString(int eventLevel) {
        String result = eventLevel + ": ";
        switch (eventLevel) {
            case 1: {
                result = result + "INFO";
                break;
            }
            case 2: {
                result = result + "WARN";
                break;
            }
            case 3: {
                result = result + "ERROR";
                break;
            }
            default: {
                result = result + "Unknown level";
            }
        }
        return result;
    }

    public static boolean isValidDN(String dn) {
        try {
            new X500Principal(dn);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

