/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.glite.pseudo.server.auditor.AuditEventEntry;
import org.glite.pseudo.server.struts.action.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDNAction
extends AbstractAction {
    private static final Logger log = LoggerFactory.getLogger(SearchDNAction.class);

    public ActionForward executeAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String dnQuery = request.getParameter("dnQuery");
        if (dnQuery != null) {
            dnQuery = dnQuery.trim();
            String sortBy = request.getParameter("sortBy");
            AuditEventEntry[] events = null;
            SearchDNAction.logEvent(101, dnQuery, request);
            if (sortBy != null && !sortBy.equals("null")) {
                log.debug("Getting events for DN={}, sorted by {}", (Object)dnQuery, (Object)sortBy);
                events = SearchDNAction.getAuditDatabaseReader(request).getPseudoEvents(dnQuery, sortBy);
            } else {
                log.debug("Getting events for DN={}", (Object)dnQuery);
                events = SearchDNAction.getAuditDatabaseReader(request).getPseudoEvents(dnQuery);
            }
            request.setAttribute("events", (Object)events);
            request.setAttribute("pseudoQuery", (Object)dnQuery);
        }
        ActionForward forward = mapping.findForward("list.events");
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)forward);
        return redirect;
    }
}

