/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.struts.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.auditor.AuditAdmin;
import org.glite.pseudo.server.auditor.Auditor;
import org.glite.pseudo.server.auditor.AuditorException;
import org.glite.pseudo.server.auditor.event.PseudoAuditEvent;
import org.glite.pseudo.server.servlet.HttpServletHelper;
import org.glite.pseudo.server.session.AdminSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAction
extends Action {
    private static final Logger log = LoggerFactory.getLogger(AbstractAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        if (this.beforeAction(form, request, response)) {
            log.debug("User is authenticated.");
            forward = this.executeAction(mapping, form, request, response);
            this.afterAction();
        } else {
            log.debug("User is not authenticated, redirecting back to the home page");
            ActionForward homeForward = mapping.findForward("go.home");
            forward = new ActionRedirect((ForwardConfig)homeForward);
        }
        return forward;
    }

    protected boolean beforeAction(ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AdminSession admin = (AdminSession)request.getSession().getAttribute("PseudoServiceAdmin");
        return admin != null;
    }

    protected abstract ActionForward executeAction(ActionMapping var1, ActionForm var2, HttpServletRequest var3, HttpServletResponse var4) throws Exception;

    protected void afterAction() {
    }

    protected static void logEvent(int level, String message, HttpServletRequest request) throws PseudoServerException {
        AdminSession admin = (AdminSession)request.getSession().getAttribute("PseudoServiceAdmin");
        Auditor auditor = HttpServletHelper.getAuditor(request.getSession().getServletContext());
        PseudoAuditEvent event = new PseudoAuditEvent(level, message, admin.getAttributes());
        try {
            auditor.logEvent(event);
        }
        catch (AuditorException e) {
            throw new PseudoServerException("Could not audit the event!", e);
        }
    }

    protected static AuditAdmin getAuditDatabaseReader(HttpServletRequest request) throws PseudoServerException {
        return HttpServletHelper.getAuditAdmin(request.getSession().getServletContext());
    }
}

