/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.standalone;

import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.glite.pseudo.common.http.HttpClientBuilder;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.standalone.StandaloneConfiguration;

public class ShutdownClient {
    static void printErrorMessageAndExit(Exception e) {
        System.err.println("Pseudonymity Service shutdown error: " + e.getMessage());
        e.printStackTrace();
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doShutdown() {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (PseudoServerException e) {
            ShutdownClient.printErrorMessageAndExit(e);
        }
        String shutdownEndpoint = String.format("http://localhost:%s/shutdown", conf.getString("shutdown_port"));
        String shutdownCommand = conf.getString("shutdown_command");
        HttpClientBuilder httpBuilder = new HttpClientBuilder(shutdownEndpoint, null, null);
        HttpClient httpClient = null;
        try {
            httpClient = httpBuilder.buildClient();
        }
        catch (Exception e) {
            ShutdownClient.printErrorMessageAndExit(e);
        }
        HttpGet get = new HttpGet(shutdownEndpoint);
        if (shutdownCommand != null) {
            get.setHeader("PSEUDO_SHUTDOWN_COMMAND", shutdownCommand);
        }
        try {
            httpClient.execute((HttpUriRequest)get);
        }
        catch (Exception e) {
            ShutdownClient.printErrorMessageAndExit(e);
        }
        finally {
            httpClient.getConnectionManager().shutdown();
        }
    }

    public static void main(String[] args) {
        if (System.getProperty("PSEUDO_SERVER_HOME") == null) {
            System.err.println("Please set the PSEUDO_SERVER_HOME environment variable before running this command!");
            System.exit(1);
        }
        try {
            String papConfigurationHome = System.getProperty("PSEUDO_SERVER_HOME") + "/conf";
            StandaloneConfiguration.initialize(papConfigurationHome);
        }
        catch (Throwable t) {
            System.err.println("Error reading Pseudonymity Service configuration. Is the PSEUDO_SERVER_HOME system property/environment variable set correctly?");
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        ShutdownClient.doShutdown();
    }
}

