/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.servlet;

import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glite.pseudo.common.pki.Certificate;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.aaclient.AAClient;
import org.glite.pseudo.server.aaclient.AAClientException;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.auditor.event.PseudoAuditEvent;
import org.glite.pseudo.server.caclient.CAClient;
import org.glite.pseudo.server.caclient.CAClientException;
import org.glite.pseudo.server.caclient.CAConnection;
import org.glite.pseudo.server.caclient.CARequest;
import org.glite.pseudo.server.caclient.CAResponse;
import org.glite.pseudo.server.servlet.AbstractServlet;
import org.glite.pseudo.server.servlet.HttpServletHelper;
import org.glite.pseudo.server.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateServlet
extends AbstractServlet {
    private static final long serialVersionUID = 2767774493123124316L;
    private static final Logger log = LoggerFactory.getLogger(CertificateServlet.class);
    private static final String REQ_AUTHZ_TOKEN_IDENTIFIER = "AuthorizationToken";
    private static final String REQ_CSR_IDENTIFIER = "CertificateSigningRequest";
    private AAClient aaClient;
    private CAClient caClient;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        this.aaClient = HttpServletHelper.getAAClient(context);
        this.caClient = HttpServletHelper.getCAClient(context);
    }

    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block9: {
            log.debug("doProcess...");
            try {
                String authorizationToken = this.getCertificateRequestParameter(request, REQ_AUTHZ_TOKEN_IDENTIFIER);
                String pemCertificateRequest = this.getCertificateRequestParameter(request, REQ_CSR_IDENTIFIER);
                log.info("AuthorizationToken=" + authorizationToken);
                log.debug("CertificateSigningRequest={}", (Object)pemCertificateRequest);
                CertificateRequest certificateRequest = null;
                try {
                    StringReader reader = new StringReader(pemCertificateRequest);
                    log.debug("Initializing PEM reader");
                    certificateRequest = CertificateRequest.readPEM((Reader)reader);
                    log.debug("Successfully decoded CSR {}", (Object)certificateRequest);
                }
                catch (Exception e) {
                    log.error("Failed to rebuild the PEM CertificateSigningRequest", (Throwable)e);
                    throw new PseudoServerException("Failed to decode PEM CertificateSigningRequest", e);
                }
                Principal principal = certificateRequest.getPrincipal();
                String certificateSubject = principal.getName();
                log.debug("Subject={}", (Object)certificateSubject);
                log.debug("check session...");
                Session session = this.sessionManager.getSession(certificateSubject, authorizationToken);
                if (session != null && session.isValid()) {
                    log.debug(session + " is valid");
                    List<Attribute> userAttributes = session.getAttributes();
                    PseudoAuditEvent newRequest = new PseudoAuditEvent(301, certificateSubject, userAttributes);
                    this.auditor.logEvent(newRequest);
                    log.debug("check certificate request against policy...");
                    if (this.certificatePolicy.isCertificateRequestValid(certificateRequest, userAttributes)) {
                        Certificate cert = this.requestCertificate(certificateRequest, principal);
                        if (cert != null) {
                            PseudoAuditEvent certIssued = new PseudoAuditEvent(302, certificateSubject, userAttributes);
                            this.auditor.logEvent(certIssued);
                            X509Certificate[] clientCerts = null;
                            clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
                            boolean registered = this.registerCertificate(clientCerts, cert);
                            if (registered) {
                                PseudoAuditEvent certRegistered = new PseudoAuditEvent(303, certificateSubject, userAttributes);
                                this.auditor.logEvent(certRegistered);
                            }
                            log.debug("Sending the CertificateResponse back to the client");
                            this.sendXMLCerfificateResponse(request, response, certificateSubject, cert);
                            log.info("Sent CertResponse back to the client.");
                        } else {
                            PseudoAuditEvent certError = new PseudoAuditEvent(302, 3, certificateSubject, userAttributes);
                            this.auditor.logEvent(certError);
                        }
                        break block9;
                    }
                    throw new PseudoServerException("CertificateSigningRequest is not conform to CertificatePolicy");
                }
                throw new PseudoServerException("Session: " + authorizationToken + "," + certificateSubject + " does not exists or is expired");
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                this.sendXMLErrorResponse(request, response, "CertResponse", e.getMessage(), e);
            }
        }
    }

    protected Certificate requestCertificate(CertificateRequest certificateRequest, Principal principal) {
        Certificate result = null;
        try {
            log.debug("get CA connection");
            CAConnection connection = this.caClient.getConnection();
            log.debug("create CA request");
            CARequest csrRequest = connection.createRequest(certificateRequest);
            log.info("send certificate request to CA server");
            connection.sendRequest(csrRequest);
            log.info("read CA server response");
            CAResponse csrResponse = connection.getResponse();
            log.debug("get certificate");
            result = csrResponse.getCertificate(principal);
        }
        catch (CAClientException e) {
            log.error("Could not obtain certificate from the online CA!", (Throwable)e);
        }
        return result;
    }

    protected boolean registerCertificate(X509Certificate[] clientCerts, Certificate cert) {
        boolean registered = false;
        try {
            if (this.aaClient != null) {
                this.aaClient.registerCertificate(ProxyUtils.getEndUserCertificate((X509Certificate[])clientCerts), cert.getCertificate());
                log.debug("Certificate successfully registered.");
                registered = true;
            } else {
                log.debug("Could not register the certificate to AA, as the AAClient was null!");
            }
        }
        catch (AAClientException e) {
            log.error("Certificate registration to the AA failed!", (Throwable)e);
        }
        return registered;
    }

    protected String getCertificateRequestParameter(HttpServletRequest request, String name) throws PseudoServerException {
        String value = request.getParameter(name);
        if (value == null || value.equals("")) {
            log.error("Request parameter " + name + " is missing or empty.");
            throw new PseudoServerException("Request parameter " + name + " is missing or empty");
        }
        return value;
    }

    protected void sendXMLCerfificateResponse(HttpServletRequest req, HttpServletResponse res, String dn, Certificate certificate) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.getXMLDeclaration());
        pw.println("<CertResponse>");
        pw.println("<Status>Success</Status>");
        pw.println("<Subject>" + dn + "</Subject>");
        String pemCertificate = certificate.getPEM();
        pw.println("<Certificate format=\"PEM\">" + pemCertificate + "</Certificate>");
        pw.println("</CertResponse>");
        log.debug("CertResponse: {}", (Object)sw.getBuffer().toString());
        res.setContentType("text/xml");
        PrintWriter out = res.getWriter();
        out.println(sw.getBuffer().toString());
        out.close();
    }
}

