/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.policy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glite.pseudo.common.pki.CertificateExtension;
import org.glite.pseudo.common.pki.CertificateExtensionFactory;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.glite.pseudo.server.policy.CertificatePolicy;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandatoryCertificateExtensionsPolicy
implements CertificatePolicy {
    private final Logger log = LoggerFactory.getLogger(MandatoryCertificateExtensionsPolicy.class);
    private Map<String, String> requiredCertificateExtensionValuesMap_ = null;
    private Map<String, Boolean> requiredCertificateExtensionCriticalMap_ = null;

    @Override
    public boolean isCertificateRequestValid(CertificateRequest request, List<Attribute> attributes) {
        List<CertificateExtension> requiredCertificateExtensions = this.getRequiredCertificateExtensions(attributes);
        List certificateRequestExtensions = request.getCertificateExtensions();
        if (!certificateRequestExtensions.containsAll(requiredCertificateExtensions)) {
            this.log.error("CertificateSigningRequest does not contain all required CertificateExtensions");
            return false;
        }
        if (!requiredCertificateExtensions.containsAll(certificateRequestExtensions)) {
            this.log.error("CertificateSigningRequest contains more CertificateExtensions than required");
            return false;
        }
        return true;
    }

    @Override
    public List<CertificateExtension> getRequiredCertificateExtensions(List<Attribute> attributes) {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        for (Attribute attribute : attributes) {
            String name = attribute.getName();
            String value = attribute.getValue();
            if (attributesMap.containsKey(name)) {
                String oldValue = (String)attributesMap.get(name);
                value = oldValue + ";" + value;
            }
            attributesMap.put(name, value);
        }
        return this.getRequiredCertificateExtensions(attributesMap);
    }

    private List<CertificateExtension> getRequiredCertificateExtensions(Map<String, String> attributes) {
        ArrayList<CertificateExtension> requiredCertificateExtensions = new ArrayList<CertificateExtension>();
        for (String extensionName : this.requiredCertificateExtensionValuesMap_.keySet()) {
            String extensionValues = this.requiredCertificateExtensionValuesMap_.get(extensionName);
            this.log.debug("Processing extension name={}, values={}", (Object)extensionName, (Object)extensionValues);
            this.log.debug("Extension should be critical: {}", (Object)this.requiredCertificateExtensionCriticalMap_.get(extensionName));
            boolean extensionCritical = this.requiredCertificateExtensionCriticalMap_.get(extensionName);
            this.log.debug("Result: {}", (Object)extensionCritical);
            if (extensionValues.indexOf("${") != -1) {
                for (String attributeName : attributes.keySet()) {
                    String placeholder = "${" + attributeName + "}";
                    if (extensionValues.indexOf(placeholder) == -1) continue;
                    String replace = "\\$\\{" + attributeName + "\\}";
                    String attributeValue = attributes.get(attributeName).toString();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("CertificateExtension values:" + extensionValues + " replace regex:" + replace + " by:" + attributeValue);
                    }
                    extensionValues = extensionValues.replaceAll(replace, attributeValue);
                }
            }
            this.log.debug("Creating a new CertificateExtension object");
            CertificateExtension extension = CertificateExtensionFactory.createCertificateExtension((String)extensionName, (String)extensionValues, (boolean)extensionCritical);
            requiredCertificateExtensions.add(extension);
        }
        return requiredCertificateExtensions;
    }

    @Override
    public void init(PseudoServerConfiguration configuration) {
        this.log.debug("Initializing certificate policy");
        Profile.Section cfgSection = configuration.getCertificatePolicyConfiguration();
        String[] ids = (String[])cfgSection.getAll((Object)"extensionId", String[].class);
        String[] criticals = (String[])cfgSection.getAll((Object)"extensionCritical", String[].class);
        String[] values = (String[])cfgSection.getAll((Object)"extensionValue", String[].class);
        if (ids.length != criticals.length || criticals.length != values.length) {
            this.log.error("The configuration for CertificatePolicy is not correct: the amount of extensionId, extensionCritical and extensionValue parameters do not match!");
        } else {
            this.log.debug("{} extensions defined in the policy.", (Object)ids.length);
            this.requiredCertificateExtensionCriticalMap_ = new HashMap<String, Boolean>();
            this.requiredCertificateExtensionValuesMap_ = new HashMap<String, String>();
            for (int i = 0; i < ids.length; ++i) {
                this.requiredCertificateExtensionValuesMap_.put(ids[i], values[i]);
                this.requiredCertificateExtensionCriticalMap_.put(ids[i], new Boolean(criticals[i]));
            }
            this.log.info("Certificate policy successfully initialized.");
        }
    }

    @Override
    public void shutdown() {
    }
}

