/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.filter;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.glite.pseudo.server.acl.AccessControlList;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.servlet.HttpServletHelper;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.VOMSValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSAttributesAuthorizationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(VOMSAttributesAuthorizationFilter.class);
    private AccessControlList m_accessControlList = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        this.m_accessControlList = HttpServletHelper.getAccessControlList(context);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        log.debug("doFilter start");
        X509Certificate[] clientCerts = null;
        clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (clientCerts == null || clientCerts.length == 0) {
            throw new ServletException("No certificate chain found from the HttpServletRequest!");
        }
        log.debug("The certificate chain length: {}", (Object)clientCerts.length);
        VOMSValidator voms = new VOMSValidator(clientCerts);
        voms.validate();
        Vector vomsAttrs = VOMSValidator.parse((X509Certificate[])clientCerts);
        log.debug("VOMS attributes amount: {}", (Object)vomsAttrs.size());
        Vector<Attribute> userAttributes = new Vector<Attribute>();
        for (int i = 0; i < vomsAttrs.size(); ++i) {
            VOMSAttribute vomsAttr = (VOMSAttribute)vomsAttrs.elementAt(i);
            List fqans = vomsAttr.getFullyQualifiedAttributes();
            for (int j = 0; j < fqans.size(); ++j) {
                log.debug("VOMS attribute {}:{}", (Object)j, fqans.get(j));
                Attribute attribute = new Attribute();
                attribute.setName("VOMS-FQAN");
                attribute.setValue(fqans.get(j).toString());
                userAttributes.add(attribute);
            }
        }
        if (this.m_accessControlList.isAuthorized(userAttributes)) {
            chain.doFilter(request, response);
        } else {
            String remoteAddress = request.getRemoteAddr();
            log.error("401: User (IP:" + remoteAddress + ") is not authorized: " + userAttributes);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(401, "Based on your VOMS attributes, you are not authorized to access this service");
        }
    }

    public void destroy() {
        log.debug("Shutting down.");
        this.m_accessControlList.shutdown();
    }
}

