/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.filter;

import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.glite.pseudo.server.acl.AccessControlList;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.servlet.HttpServletHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectDNAuthorizationFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SubjectDNAuthorizationFilter.class);
    private AccessControlList m_accessControlList = null;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext context = filterConfig.getServletContext();
        this.m_accessControlList = HttpServletHelper.getAdministratorAccessControlList(context);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        log.debug("doFilter start");
        X509Certificate[] clientCerts = null;
        clientCerts = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (clientCerts == null || clientCerts.length == 0) {
            throw new ServletException("No certificate chain found from the HttpServletRequest!");
        }
        log.debug("The certificate chain length: {}", (Object)clientCerts.length);
        X509Certificate endEntityCert = ProxyUtils.getEndUserCertificate((X509Certificate[])clientCerts);
        Vector<Attribute> userAttributes = new Vector<Attribute>(1);
        Attribute attribute = new Attribute();
        attribute.setName("Certificate-DN");
        attribute.setValue(((Object)endEntityCert.getSubjectDN()).toString());
        userAttributes.add(attribute);
        if (this.m_accessControlList.isAuthorized(userAttributes)) {
            filterChain.doFilter(request, response);
        } else {
            String remoteAddress = request.getRemoteAddr();
            log.error("401: User (IP:" + remoteAddress + ") is not authorized: " + userAttributes);
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.sendError(401, "Based on your X.509 certificate, you are not authorized to access this page");
        }
    }

    public void destroy() {
        log.debug("Shutting down.");
        this.m_accessControlList.shutdown();
    }
}

