/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.config;

import java.io.File;
import java.io.IOException;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoServerConfiguration
extends Ini {
    private static final long serialVersionUID = 2767774490991448133L;
    private static final Logger log = LoggerFactory.getLogger(PseudoServerConfiguration.class);
    protected static final String CFG_SECTION_CACLIENT = "CAClient";
    protected static final String CFG_SECTION_AACLIENT = "AAClient";
    protected static final String CFG_SECTION_CERTIFICATE_POLICY = "CertificatePolicy";
    protected static final String CFG_SECTION_DN_BUILDER = "DNBuilder";
    protected static final String CFG_SECTION_AUDITOR = "Auditor";
    protected static final String CFG_SECTION_AUDIT_ADMIN = "AuditAdmin";
    protected static final String CFG_SECTION_ATTRIBUTE_DEFINITIONS = "AttributeDefinitions";
    protected static final String CFG_SECTION_ACL = "ACL";
    protected static final String CFG_SECTION_ADMINISTRATOR_ACL = "AdministratorACL";
    public static final String CFG_IMPLEMENTATION_ID = "implementation";

    public PseudoServerConfiguration(String iniFile) throws InvalidFileFormatException, IOException {
        super(new File(iniFile));
        log.info("Successfully constructed a new configuration from the file {}", (Object)iniFile);
    }

    public Profile.Section getCAClientConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_CACLIENT);
    }

    public Profile.Section getAAClientConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_AACLIENT);
    }

    public Profile.Section getCertificatePolicyConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_CERTIFICATE_POLICY);
    }

    public Profile.Section getDNBuilderConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_DN_BUILDER);
    }

    public Profile.Section getAuditorConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_AUDITOR);
    }

    public Profile.Section getAuditAdminConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_AUDIT_ADMIN);
    }

    public Profile.Section getAttributeDefinitionsConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_ATTRIBUTE_DEFINITIONS);
    }

    public Profile.Section getAccessControlListConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_ACL);
    }

    public Profile.Section getAdminAccessControlListConfiguration() {
        return (Profile.Section)this.get(CFG_SECTION_ADMINISTRATOR_ACL);
    }
}

